#version 130
uniform sampler2D font;
uniform vec4 color;
uniform vec4 shadow;
void main()
{
     vec2 coord1   = gl_TexCoord[0].xy;
     vec2 coord2   = coord1 - 0.003;
     float signed1 = texture2D(font, coord1).a;
     float signed2 = texture2D(font, coord2).a;
     float alpha1  = smoothstep(0.4,0.6,signed1);
     float alpha2  = smoothstep(0.3,0.6,signed2);
     vec4 color1   = vec4(color.rgb,  color.a  * alpha1);
     vec4 color2   = vec4(shadow.rgb, shadow.a * alpha2);
     vec4 outcol   = vec4(color1.rgb*color1.a + color2.rgb * (1.0-color1.a), max(color1.a, color2.a));
    gl_FragColor   = outcol;
}