var scene3 = new Scene();
scene3.cameraStart = {x: 13, y: 0, z: 100}
scene3.init = function() {
    if (this.inited)
        return

    this.material = scene1.material;
    this.material2 = scene1.material2;
    this.geometry = new THREE.SphereGeometry(3, 16, 16);

    this.org = [];
    this.group = new THREE.Object3D;

    var xgrid = 10,
          ygrid = 10;
          zgrid = 20;
    var origin = [];
    for ( i = 0; i < xgrid; i ++ )
    for ( j = 0; j < ygrid; j ++ )
    for ( k = 0; k < zgrid; k ++ ) {
      var mat;
      if (i % 2 == 0) {
        mat = this.material;
      } else {mat = this.material2}
      var cube = new THREE.Mesh(this.geometry, mat);
      x = 10 * ( i - xgrid/2 );
      y = 10 * ( j - ygrid/2 );
      z = 5 * ( k - zgrid/2 );
      cube.position.set( x, y, z );
      this.group.add(cube);
      var pos = [x, y, z];
      this.org.push(pos);
    }

    this.scene.add(this.group);
    this.ambientLight = new THREE.AmbientLight(0x202020);
    this.scene.add(this.ambientLight);

    this.directionalLight = new THREE.DirectionalLight(0xffffff, 1);
    this.directionalLight.position.set(0,0,1).normalize();
    this.scene.add(this.directionalLight);


    this.inited = true;
};

scene3.render = function(row) {
    // for (var i = 0; i < this.cubes.length; i++) {
    //     this.cubes[i].position.z += Math.sin(this.cubes[i].position.y + row / 300) * .1;
    //     this.cubes[i].position.y += Math.cos(this.cubes[i].position.x + row / 100) * .05;
    //     orgPos++;
    //   };


    for (var i = 0; i < this.group.children.length; i++) {
        var cube = this.group.children[i];
          cube.rotation.x += 0.01;
          cube.rotation.y += 0.01;
          cube.rotation.z += 0.01;
          last = i;
          // cube.scale.x = Math.cos(row / 1000) * 1.5;
          // cube.scale.y = cube.scale.x;
          // cube.scale.z = cube.scale.x;
          if (row < 1840) {
            cube.position.y = cube.position.y + Math.sin(this.org[i][1] + row / 10) * 0.5;
            cube.position.x = cube.position.x + Math.sin(this.org[i][0] + row / 10) * 0.5;
            
          } else if (row > 1840) {
            cube.position.y += 0.5;
          }
      /*  var cube = group.children[i];
        if (time > 6000) {
          cube.position.y = cube.position.y + Math.sin((0 + i*i) / 500) * 0.5;
          cube.position.x = origin[i][0] + Math.cos((0 + i*i) / 100) * 0.5;
        } else {
          cube.position.y = cube.position.y + Math.sin((time + i*i) / 500) * 0.5;
          cube.position.x = origin[i][0] + Math.cos((time + i*i) / 100) * 0.5;
        }*/
      }

    
      this.camera.position.z -= 0.1;
      this.camera.position.x = THREE.Math.degToRad(Math.sin(row / 100)) * 10;
      this.camera.rotation.z += 0.01;



    this.material.emissive.setHSL( 0.5, 1, 0.35 * ( 0.5 + 0.5 * Math.cos( 35 * row / 50 ) ) );
    this.material2.emissive.setHSL( 0.06, 1, 0.35 * ( 0.5 + 0.5 * Math.cos( 35 * row / 100 ) ) );


        this.material.emissive.setHSL( 0.5, 1, 1 * ( 0.5 + 0.5 * Math.cos( 35 * row / 20 ) ) );
    this.material2.emissive.setHSL( 0.06, 1, 1 * ( 0.5 + 0.5 * Math.cos( 35 * row / 40 ) ) );
    this.directionalLight.position.z = Math.sin(row / 1000);
};
