var scene2 = new Scene();
scene2.cameraStart = {x: 0, y: 0, z: 5}

scene2.init = function() {
    if (this.inited)
        return

    // Add objects, etc
    console.log('scene2 inited');
    this.directionalLight = new THREE.DirectionalLight(0xffffff, 1);
    this.directionalLight.position.set(1,1,1).normalize();
    this.scene.add(this.directionalLight);

    this.material = scene1.material;
    this.material2 = scene1.material2;

    this.megaCube = new THREE.Mesh(new THREE.CubeGeometry(5,5,5), this.material);
    this.scene.add(this.megaCube);

    this.sphere = new THREE.Mesh(
        new THREE.SphereGeometry(10, 16, 16)
    );
    this.group = new THREE.Object3D;

    this.sphereFaces = this.sphere.geometry.faces;
    this.cubes = [];

    var i, v, cube, sphereFace, vertices, scaleValue;
    for (i = 0; i < this.sphereFaces.length; i++) {
        // Find the sphere face
        sphereFace = this.sphereFaces[i];
        var material;
        if (i % 2 == 0) {
            material = this.material;
        } else {
            material = this.material2;
        }
        // Create a cube
        cube = new THREE.Mesh(
            new THREE.CubeGeometry(1, 1, 1),
            material
        );

        // Grab the cube vertices (each corner)
        vertices = cube.geometry.vertices;
        for (v = 0; v < vertices.length; v++) {
            // Shift each vertex by half its size
            // This means it will scale from the bottom rather than the centre
            vertices[v].z -= 0.5;
        };

        // Move the cube to the sphere face
        cube.position = sphereFace.centroid;

        // Rotate the cube so it faces towards the centre of the sphere
        cube.lookAt(this.sphere.position);

        // Scale the cube so it is smaller near the poles of the sphere
        scaleValue = Math.abs(cube.position.y) / 100;
        cube.scale.x = 1 - scaleValue * 0.7;
        cube.scale.y = 1 - scaleValue * 0.7;
        cube.scale.z = 1 - scaleValue * 0.7;

        // Assign scale value to the cube so we can grab it later
        cube.scaleValue = 1 - (scaleValue * 0.7);

        // Add the cube to the array
        this.cubes.push(cube);
        this.group.add(cube);
        // Add the cube to the scene
    };
    this.scene.add(this.group);

    this.greetingsAdded = false;
    this.greetIndigo = false;
    this.greetLegendary = false;
    this.greetDarklite = false;
    this.greetTerje = false;
    this.greetEveryone = false;
    this.greetZomg = false;

    this.inited = true;
};

scene2.render = function(row) {
    var lel = this.tracks.misc.getValue(row);
    for (var i = 0; i < this.cubes.length; i++) {
        var cube = this.cubes[i];
        if (row < 260) {
                cube.scale.y = lel;
                cube.scale.x = lel;
                cube.scale.z = lel;
        } else if (row > 254 && row < 479) {
                cube.scale.z = lel;
        } else if (row > 479 && row < 632) {
                cube.scale.y = lel;
                cube.scale.x = lel;
                cube.scale.z = lel;
        }
        if (row > 632) {
            cube.scale.z = lel;
        }
        if (row >= 875) {
            cube.scale.z = lel;
            cube.scale.y = lel;
            cube.scale.x = lel;
            cube.scale.z = lel;
            this.sphere.position.x += 0.1;
        }
        if (row > 254) {
            cube.rotation.y = Math.sin(row / 5);
        }
    }
    if (row >= 650) {
        // Could have been done with a simple loop, but i don't give two shits atm
        if (this.greetingsAdded == false) {
            this.greetings = new THREE.Sprite(scene1.createSpriteMat('Greetings to:', '200'));
            this.greetings.scale.set( 10, 10, 1 ); // CHANGED
            this.greetings.position.set(20, 0, 0);
            this.scene.add(this.greetings);
            this.greetingsAdded = true;
        }

        if (this.greetingsAdded && this.greetIndigo == false && row >= 680) {
            this.scene.remove(this.greetings);
            this.indigo = new THREE.Sprite(scene1.createSpriteMat('Indigo', '200'));
            this.indigo.scale.set( 10, 10, 1 ); // CHANGED
            this.indigo.position.set(20, 0, 0);
            this.scene.add(this.indigo);
            this.greetIndigo = true;
        }

        if (this.greetIndigo && this.greetLegendary == false && row >= 710) {
            this.scene.remove(this.indigo);
            this.legendary = new THREE.Sprite(scene1.createSpriteMat('Legendary', '200'));
            this.legendary.scale.set( 10, 10, 1 ); // CHANGED
            this.legendary.position.set(20, 0, 0);
            this.scene.add(this.legendary);
            this.greetLegendary = true;   
        }

        if (this.greetLegendary && this.greetDarklite == false && row >= 740) {
            this.scene.remove(this.legendary);
            this.darklite = new THREE.Sprite(scene1.createSpriteMat('Darklite', '200'));
            this.darklite.scale.set( 10, 10, 1 ); // CHANGED
            this.darklite.position.set(20, 0, 0);
            this.scene.add(this.darklite);
            this.greetDarklite = true;   
        }

        if (this.greetDarklite && this.greetTerje == false && row >= 770) {
            this.scene.remove(this.darklite);
            this.terje = new THREE.Sprite(scene1.createSpriteMat('Terje_', '200'));
            this.terje.scale.set( 10, 10, 1 ); // CHANGED
            this.terje.position.set(20, 0, 0);
            this.scene.add(this.terje);
            this.greetTerje = true;   
        }

        if (this.greetTerje && this.greetZomg == false && row >= 800) {
            this.scene.remove(this.terje);
            this.zomg = new THREE.Sprite(scene1.createSpriteMat('Zomgtronics', '200'));
            this.zomg.scale.set( 10, 10, 1 ); // CHANGED
            this.zomg.position.set(20, 0, 0);
            this.scene.add(this.zomg);
            this.greetZomg = true;   
        }

        if (this.greetZomg && this.greetEveryone == false && row >= 830) {
            this.scene.remove(this.zomg);
            this.everyone = new THREE.Sprite(scene1.createSpriteMat('and everyone else! <3', '155'));
            this.everyone.scale.set( 10, 10, 1 ); // CHANGED
            this.everyone.position.set(20, 0, 0);
            this.scene.add(this.everyone);
            this.greetEveryone = true;   
        }

        if (this.greetEveryone && row >= 860) {
            this.everyone.position.x += 0.1;
        }
        if (row >= 890) {
            this.scene.remove(this.everyone);
        }
    }
    this.megaCube.rotation.y = Math.sin(row / 10);
    this.megaCube.rotation.x = Math.cos(row / 10);

    this.group.rotation.y = Math.sin(row / 100);
    this.group.rotation.x = Math.cos(row / 100);

    this.camera.position.x = this.tracks.cX.getValue(row);
    this.camera.position.y = this.tracks.cY.getValue(row);
    this.camera.position.z = this.tracks.cZ.getValue(row);
    this.material.emissive.setHSL( 0.06, 1, 0.35 * ( 0.5 + 0.5 * Math.cos( 35 * row / 100 ) ) );
    this.material2.emissive.setHSL( 0.55, 0.5, 0.35 * ( 0.5 + 0.5 * Math.cos( 35 * row / 100 ) ) );
};