var scene1 = new Scene();
scene1.cameraStart = {x: 0, y: 0, z: 5}
scene1.init = function() {
    if (this.inited)
        return

    this.material = new THREE.MeshLambertMaterial( { color: 0x666666, emissive: 0xff0000, ambient: 0x000000, shading: THREE.SmoothShading, wireframe: false } )
    this.material2 = new THREE.MeshLambertMaterial( { color: 0x666666, emissive: 0xff0000, ambient: 0x000000, shading: THREE.SmoothShading, wireframe: false } )
    this.cube = new THREE.Mesh(new THREE.CubeGeometry(1,1,1), this.material);
    this.scene.add(this.cube);
    this.sphere = new THREE.Mesh(new THREE.SphereGeometry(1,16,16), this.material2);

    this.ambientLight = new THREE.AmbientLight(0x202020);
    this.scene.add(this.ambientLight);

    this.directionalLight = new THREE.DirectionalLight(0xffffff, 1);
    this.directionalLight.position.set(1,1,1).normalize();
    this.scene.add(this.directionalLight);    

    this.addedIntroText = false;
    this.addedPresentsText = false;
    this.inited = true;
};

scene1.createSpriteMat = function(text, fontSize) {
    var canvas = document.createElement('canvas');
    var size = window.innerWidth; // CHANGED
    canvas.width = size;
    canvas.height = size;
    var context = canvas.getContext('2d');
    context.fillStyle = '#fff'; // CHANGED
    context.textAlign = 'center';
    var fontBase = 1920;
    var ratio = fontSize / fontBase;
    fontSize = ratio * window.innerWidth;
    console.log(fontSize);
    context.font = 'Bold ' + fontSize + 'px Arial';
    context.fillText(text, size / 2, size / 2);

    var amap = new THREE.Texture(canvas);
    amap.needsUpdate = true;

    var mat = new THREE.SpriteMaterial({
        map: amap,
        transparent: false,
        useScreenCoordinates: false,
        color: 0xffffff // CHANGED
    });

    return mat;
};

scene1.addIntroText = function() {
    this.introText = new THREE.Object3D();
    if (this.addedIntroText === false) {
        this.torAndHkan = new THREE.Sprite(this.createSpriteMat('_tor & djhkan', '150'));
        this.torAndHkan.scale.set( 10, 10, 1 ); // CHANGED
        this.torAndHkan.position.y = -2;
        this.scene.add(this.torAndHkan);

        this.atTheGathering = new THREE.Sprite(this.createSpriteMat('@ The Gathering 2014', '115'));
        this.atTheGathering.scale.set( 10, 10, 1 ); // CHANGED
        this.atTheGathering.position.y = -3;
        this.scene.add(this.atTheGathering);
        this.addedIntroText = true;
    } 
};

scene1.addPresentsText = function() {
    if (this.addedPresentsText === false) {
        this.scene.remove(this.torAndHkan);
        this.scene.remove(this.atTheGathering);

        this.presents = new THREE.Sprite(this.createSpriteMat('Presents', '150'));
        this.presents.scale.set( 10, 10, 1 ); // CHANGED
        this.presents.position.y = -2;
        this.scene.add(this.presents);

        this.cubesAndSpheres = new THREE.Sprite(this.createSpriteMat('Cubes & Spheres', '115'));
        this.cubesAndSpheres.scale.set( 10, 10, 1 ); // CHANGED
        this.cubesAndSpheres.position.y = -3;
        this.scene.add(this.cubesAndSpheres);
        this.addedPresentsText = true;
    } 
};

scene1.render = function(row) {
    if (row > 41 && row < 137) {
        this.addIntroText();
        this.torAndHkan.position.x = Math.sin(row / 10) * 0.5;
        this.atTheGathering.position.x = Math.sin(row / 10) * 0.5;
    }
    if (row > 137) {
        this.addPresentsText();
        this.presents.position.x = Math.sin(row / 10) * 0.5;
        this.cubesAndSpheres.position.x = Math.sin(row / 10) * 0.5;
    }

    this.sphere.rotation.y = Math.sin(row / 5);
    this.cube.rotation.y = this.sphere.rotation.y;
    this.sphere.rotation.x = Math.cos(row / 5);
    this.cube.rotation.x = this.sphere.rotation.x;

    this.cube.position.x = Math.sin(row / 10) * 5;
    this.cube.position.y = Math.cos(row / 5) * 3;
    this.sphere.position.x = this.cube.position.x;
    this.sphere.position.y = this.cube.position.y;



    if (this.tracks.misc.getValue(row) === 1) {
        this.scene.remove(this.cube);
        this.scene.add(this.sphere);
    } else if (this.tracks.misc.getValue(row) === 2) {
        this.scene.add(this.cube);
        this.scene.remove(this.sphere);
    }

    this.material.emissive.setHSL( 0.04, 1, 0.35 * ( 0.5 + 0.5 * Math.cos( 35 * row / 100 ) ) );
    this.material2.emissive.setHSL( 0.55, 0.5, 0.35 * ( 0.5 + 0.5 * Math.cos( 35 * row / 100 ) ) );

    this.camera.position.x = this.tracks.cX.getValue(row);
    this.camera.position.y = this.tracks.cY.getValue(row);
    this.camera.position.z = this.tracks.cZ.getValue(row);

    this.camera.rotation.x = (Math.PI / 180) * this.tracks.crX.getValue(row);
    this.camera.rotation.y = (Math.PI / 180) * this.tracks.crY.getValue(row);
    this.camera.rotation.z = (Math.PI / 180) * this.tracks.crZ.getValue(row);

    this.cube.rotation.z += 0.01;
};
