function starfield(radius, numstars)
{
	this.cam_orbit_radius = 1500;
	if(radius !== undefined) {
		this.cam_orbit_radius = radius;
	}

	if (numstars === undefined)
	{
		this.ITERATIONS = 5500;
	} else
	{
		this.ITERATIONS = numstars;
	}
	
	this.geometry = new THREE.Geometry();
	
	for ( i = 0; i < ITERATIONS; i ++ ) {
		var vertex = new THREE.Vector3();
		
		//vertex.x = Math.floor((Math.random()*1000)-500);
		//vertex.y = Math.floor((Math.random()*1000)-500);
		//vertex.z = Math.floor((Math.random()*1000)-500);

		var phi = ((2*Math.PI) * Math.random());
		var feta = Math.acos( (2 * Math.random()) -1) ;
		//var feta = Math.acos(-1) * (2 * Math.random() -1);

		vertex.x = cam_orbit_radius * Math.sin(feta)*Math.cos(phi);
		vertex.y = cam_orbit_radius * Math.sin(feta)*Math.sin(phi);
		vertex.z = cam_orbit_radius * Math.cos(feta);

		cam_orbit_radius-=0.01;
		
		geometry.vertices.push(vertex);
	}

    // attributes
    attributes = {
        alpha: { type: 'f', value: [] },
    };

    tex.stardisc = load_texture("gfx/disc.png","star sprite");

    // uniforms
    uniforms = {
        color: { type: "c", value: new THREE.Color( 0xffffff ) },
        texture: { type: "t", value: tex.stardisc },
    };

	var shaderMaterial = new THREE.ShaderMaterial( {
		uniforms:       uniforms,
		attributes:     attributes,
		vertexShader:   shaders.vertexShader_stars,
		fragmentShader: shaders.fragmentShader_stars,
		transparent: true
	});

	particles = new THREE.ParticleSystem(geometry, shaderMaterial);
	return particles;
}