function scene_titlescreen() {
	this.scenename = "Title screen";

	this.load = function() {
		loading_console_write('Creating title screen');

		//renderer.setClearColor( 0xff0000, 1.0 );

		var width = wWidth;
		var height = wHeight;

		this.camera = new THREE.PerspectiveCamera( 60, 16/9, 1, 21000 );
		//this.camera = new THREE.OrthographicCamera( - width / 2, width / 2, height / 2, - height / 2, 1, 2000 );
		this.camera.position.z = -10;

		this.scene = new THREE.Scene();
		//this.scene.add(this.camera);

		//this.scene.fog = new THREE.Fog(0x000000, 10000,20100);

		this.glow_scene = new THREE.Scene();
		this.glow_renderpass = new THREE.RenderPass(this.glow_scene, this.camera);
		
		
		tex.skybox = load_texture(texture_dir+'skybox/starscape_3.jpg','starmap skybox texture');
		this.skybox_material = new THREE.MeshBasicMaterial( { map: tex.skybox, side: THREE.DoubleSide } );
		this.skybox_geometry = new THREE.CubeGeometry(4000,4000,4000);
		this.skybox = new THREE.Mesh(this.skybox_geometry, this.skybox_material);
		this.scene.add(this.skybox);

		//this.cosmos = starfield();
		//this.scene.add(this.cosmos);


		tex.earth2d = load_texture(texture_dir+'title_earth.png','earth mask');
		tex.sun2d = load_texture(texture_dir+'title_sun.png','intro sun');

		this.earth_geometry = new THREE.PlaneGeometry(100,60, 1,1);
		this.earth_material = new THREE.MeshBasicMaterial(
			{
				map: tex.earth2d,
				side: THREE.DoubleSide,
				transparent:true
			}
		);
		this.earth = new THREE.Mesh(this.earth_geometry, this.earth_material);
		this.earth_mask = new THREE.Mesh(this.earth_geometry, this.earth_material);

		//this.earth = this.createCube(20, 10, 'title_earth.png','earth mask');
		this.earth.position.set(0,-6,30);
		this.earth.rotation.y = deg2rad(180);
		this.scene.add(this.earth);

		this.earth_mask.position.set(0,-6,30);
		this.earth_mask.rotation.y = deg2rad(180);
		this.glow_scene.add(this.earth_mask);

		this.sun_geometry = new THREE.PlaneGeometry(100,53, 1,1);
		this.sun_material = new THREE.MeshBasicMaterial(
			{
				map: tex.sun2d,
				side: THREE.DoubleSide,
				transparent:true
			}
		);
		this.sun = new THREE.Mesh(this.sun_geometry, this.sun_material);

		//this.earth = this.createCube(20, 10, 'title_earth.png','earth mask');
		this.sun.position.set(-0.3,-4,31);
		this.sun.rotation.y = deg2rad(180);
		this.glow_scene.add(this.sun);

		this.hblurPass = new THREE.ShaderPass(THREE.MassiveHorizontalBlurShader);
		this.hblurPass.uniforms['h'].value = 0.3 / wWidth;
		this.vblurPass = new THREE.ShaderPass(THREE.MassiveVerticalBlurShader);
		this.vblurPass.uniforms['v'].value = 0.3 / wHeight;

		this.hblurPass2 = new THREE.ShaderPass(THREE.MassiveHorizontalBlurShader);
		this.hblurPass2.uniforms['h'].value = 0.1 / wWidth;
		this.vblurPass2 = new THREE.ShaderPass(THREE.MassiveVerticalBlurShader);
		this.vblurPass2.uniforms['v'].value = 0.1 / wHeight;

		this.bloompass = new THREE.BloomPass();
		this.vblur2 = new THREE.ShaderPass(THREE.VerticalBlurShader);
		this.hblur2 = new THREE.ShaderPass(THREE.HorizontalBlurShader);

		this.overlaypass = new THREE.OverlayPass(buffer1, 1.0);
		this.texturepass = new THREE.TexturePass(buffer1, 1.0);
		this.savepass = new THREE.SavePass(buffer1, 1.0);

		this.additivepass = new THREE.ShaderPass(THREE.AdditiveBlendShader2);
		this.additivepass.uniforms.tDiffuse2.value = buffer1;
		this.additivepass.uniforms.color.value = new THREE.Color( 0xC6F0FF );

		this.titlebox = this.createCube(10.24*1.2, 5.12*1.2, 'title.png', 'title label');
		this.titlebox.position.set(0, -0.4, 1);
		this.scene.add(this.titlebox);

		this.subtitlebox = this.createCube(5.12*1.4, 0.64*1.4, 'sub-title.png', 'subtitle label');
		this.subtitlebox.position.set(0, -1.6, 1);
		this.scene.add(this.subtitlebox);
		this.subtitlebox.opacity = 0;


		this.camera.lookAt(new THREE.Vector3(0, 0, 0));


		//Timings
		this.titlebox.start = .5;
		this.titlebox.duration = 12;

		this.subtitlebox.start = 3;
		this.subtitlebox.duration = 6;

		this.renderpass = new THREE.RenderPass(this.scene, this.camera);
	}

	this.createCube = function(w, h, tex, tex_desc) {
		var cubeGeometry = new THREE.CubeGeometry( w, h, 1 );
		var tex_title = load_texture(texture_dir+tex, tex_desc);
		var cubeMaterial = new THREE.MeshBasicMaterial({map: tex_title, transparent: true });
		cube = new THREE.Mesh( cubeGeometry, cubeMaterial );
		cube.material = cubeMaterial;

		return cube;
	}

	this.render = function(t, percent) {
		// Fade in from 2 to 14 seconds demotime
		this.titlebox.material.opacity = getVal("var1");
		this.subtitlebox.material.opacity = getVal("var2");

		/*
		if(percent > this.titlebox.start && percent < (this.titlebox.start + this.titlebox.duration)) {
			var s = this.easeOutCubic(percent, .7, .3, 1.0);
			this.titlebox.scale.set(s, s, 1.0);
		}
		*/
		var s = getVal("var3");
		this.titlebox.scale.set(s, s, 1.0);

		this.skybox.rotation.x = -t / 50;
		//this.earth.rotation.x = t*4;

		//renderer.render(this.scene, this.camera);
		//effectcomposer.doPass(this.renderpass);
		//effectcomposer.doPass(final_pass);

		//this.sun.position.y = -5.7 +t/10;
		this.sun.position.y = -3.2 +t/10;

		this.sun.visible = false;
		renderer.render(this.glow_scene, this.camera, buffer2, true);

		this.sun.visible = true;
		effectcomposer.doPass(this.glow_renderpass);
		effectcomposer.doPass(this.hblurPass);
		effectcomposer.doPass(this.vblurPass);

		// wtf.. readbuffer is black unless i do this!
		effectcomposer.doPass(this.savepass);
		effectcomposer.doPass(this.texturepass);

		this.overlaypass.uniforms.overlayTexture.value = buffer2;
		effectcomposer.doPass(this.overlaypass);
		//effectcomposer.doPass(this.bloompass);
		//effectcomposer.doPass(this.vblur2);
		//effectcomposer.doPass(this.hblur2);
		effectcomposer.doPass(this.hblurPass2);
		effectcomposer.doPass(this.vblurPass2);
		effectcomposer.doPass(this.savepass);

		//effectcomposer.doPass(this.texturepass);

		effectcomposer.doPass(this.renderpass);
		effectcomposer.doPass(this.additivepass);

		effectcomposer.doPass(final_pass);
	}

	this.constrain = function(t, min, max) {
		return Math.min(max, Math.max(t, min));
	}

	this.easeOutCubic = function (t, b, c, d) {
		return c*((t=t/d-1)*t*t + 1) + b;
	}
}