function scene_line () {
	this.scene_name = "Line";

	this.load = function() {
		loading_console_write('Creating line');

		this.camera = new THREE.PerspectiveCamera(45, 16/9, 0.1, 2000); // view angle, aspect, near, far
		this.scene = new THREE.Scene();

		this.scene.add(this.camera);

		this.createLine();

		this.camera.position.set(0, 30, -60);
		this.camera.lookAt(this.line.position);
	}

	this.createLine = function() {

		var color = 0xffee00;
		var x = y = z = 0;

		var shape = new THREE.Shape();
		shape.moveTo(x,y);
		shape.quadraticCurveTo(x + 5, y - 8, x + 9, y - 1);
		shape.quadraticCurveTo(x + 10, y - 1, x + 11.5, y - 4);
		shape.quadraticCurveTo(x + 11.5, y, x + 11.5, y + 4);
		shape.quadraticCurveTo(x + 10, y + 1, x + 9, y + 1);
		shape.quadraticCurveTo(x + 5, y + 8, x, y);

		var points = shape.createPointsGeometry();
		this.line = new THREE.Line( points, new THREE.LineBasicMaterial( { color: color, linewidth: 2 } ) );
		this.line.position.set( x, y, z );
//		this.line.rotation.set( rx, ry, rz );
//		this.line.scale.set( s, s, s );
		this.scene.add( this.line );
	}

	this.render = function(demo_time) {
		this.camera.position.set(Math.sin(demo_time) * 30, 30, Math.cos(demo_time) * -60);
		this.camera.lookAt(this.line.position);
		
		renderer.render(this.scene, this.camera);
	}
}