var container, camera, renderer, effectcomposer, container, controls, stats, light, music, audigain;
var launchpad;

var wWidth = 0;
var wHeight = 0;
var wBufferWidth = 0;
var wBufferHeight = 0;
var music_started = 0;
var audio_delay = 0;

var final_pass_shader;

var globe, globe_glow;

var buffer1, buffer2, buffer3, buffer4; // full screen buffers

// 22:46 <@NiteLite> noise funksjoner for webgl: https://github.com/ashima/webgl-noise/tree/master/src
// sol-shader: http://alteredqualia.com/three/examples/webgl_shader_fireball.html
// http://blog.thematicmapping.org/2013/09/creating-webgl-earth-with-threejs.html noen har gjort det før.
// Borealis videos:
// http://www.youtube.com/watch?v=NYXwRU2Vrq0

var texture_dir = 'gfx/';
var tex = {};

var syncDevice = new JSRocket.SyncDevice(),

	//Beats per minute of your demo tune
	BPM = 140,

	//The resolution between two beats, four is usually fine,- eight adds a bit more finer control
	ROWS_PER_BEAT = 8,

	//we calculate this now, so we can translate between rows and seconds later on
	ROW_RATE = BPM / 60 * ROWS_PER_BEAT,

	//the current row we're on
	row,

	// Are we live?!
	demoMode = true;

var rocketTracks = {
	"scene": 0,
	"percent": 0,
	"fadeToBlack": 0,
	"var1": 0,
	"var2": 0,
	"var3": 0,
	"var4": 0,
	"var5": 0,
	"var6": 0,
	"var7": 0,
	"p1_lat": 0,
	"p1_lon": 0,
	"r1_x": 0,
	"r1_y": 0,
	"r1_z": 0,
	"p2_lat": 0,
	"p2_lon": 0,
	"r2_x": 0,
	"r2_y": 0,
	"r2_z": 0,
	"radius": 0,
	"sun_orbit": 0,
	"lens": 0,
	"rgbshift": 0,
	"vignette": 0,
	"scanlines": 0,
	"grain": 0
};

function getVal(track) {
	if(rocketTracks[track] === 0) {
		return 0;
	}
	var v = rocketTracks[track].getValue(row);

	if(isNaN(v)) {
		return 0;
	}
	return v;
}

var _audio = new Audio();

var shaders = function(){};

var geos = function(){}; // geometries

var meshes = function(){};
var materials = function(){};
var lights = function(){};
var scenes = function(){};


//var scene_composer = new scene_composer();
var launchpad = new _launchpad();

var clock = new THREE.Clock();
var dt = 0.0; // demo-time. clock that starts after loading.

function demo_init()
{
	create_loading_console();

	SHADER_LOADER.load(
		function (data)
		{
			loading_console_write("Shady shaders are shady");

			loading_console_write(" * Glow shader");
			shaders.vertexShader_stars = data.stars.vertex;
			shaders.fragmentShader_stars = data.stars.fragment;

			loading_console_write(" * Glow shader");
			shaders.vertexShader_glow = data.glow.vertex;
			shaders.fragmentShader_glow = data.glow.fragment;

			loading_console_write(" * Planet shader");
			shaders.vertexShader_globe = data.globe.vertex;
			shaders.fragmentShader_globe = data.globe.fragment;

			loading_console_write(" * Cloud shader");
			shaders.vertexShader_globeclouds = data.globeclouds.vertex;
			shaders.fragmentShader_globeclouds = data.globeclouds.fragment;

			loading_console_write(" * Sun shader");
			shaders.vertexShader_sun = data.sun.vertex;
			shaders.fragmentShader_sun = data.sun.fragment;

			loading_console_write(" * Boris shader");
			shaders.vertexShader_aurora = data.aurora.vertex;
			shaders.fragmentShader_aurora = data.aurora.fragment;

			loading_console_write(" * Boris blurshader");
			shaders.vertexShader_aurorablur = data.aurorablur.vertex;
			shaders.fragmentShader_aurorablur = data.aurorablur.fragment;

			loading_console_write(" * Final pass shader");
			shaders.fragmentShader_final_pass = data.final_pass.fragment;
			shaders.fragmentShader_overlay = data.overlay.fragment;

			loading_console_write(" * Static shader");
			shaders.vertexShader_staticnoise = data.staticnoise.vertex;
			shaders.fragmentShader_staticnoise = data.staticnoise.fragment;

			loading_console_write(" * Generic vertex shader");
			shaders.vertexShader_generic = data.generic.vertex;

			loading_console_write(" * Ray Marching shader");
			shaders.fragmentShader_raymarching = data.raymarching.fragment;

			loading_console_write(" * Ray Marching 2 shader");
			shaders.fragmentShader_raymarching2 = data.raymarching2.fragment;

			loading_console_write(" * Text particles");
			shaders.vertexShader_textparticles = data.textparticles.vertex;
			shaders.fragmentShader_textparticles = data.textparticles.fragment;

			loading_console_write(" * Terrain: Mountain shader");
			shaders.vertexShader_terrain_mountain = data.terrain_mountain.vertex;
			shaders.fragmentShader_terrain_mountain = data.terrain_mountain.fragment;

			loading_console_write(" * Microscope");
			shaders.vertexShader_microscope = data.microscope.vertex;
			shaders.fragmentShader_microscope = data.microscope.fragment;

			loading_console_write(" * Inner glow");
			shaders.vertexShader_innerglow = data.innerglow.vertex;
			shaders.fragmentShader_innerglow = data.innerglow.fragment;
			
			console.log("loaded shaders");
			

			demo_init3();
		}
	);
}

// The shader loader is non-blocking, so we split the
// loading function in two to get our code executed in the right order.
function demo_init3()
{
	loading_console_write("I have no idea what I'm doing..");
	console.log("demo init stage 2")
	//scene = new THREE.Scene();

	$(document).keypress(function(){
		if (event.keyCode == 'm'.charCodeAt())
		{
			_audio.muted = !_audio.muted;
		}
	});

	//console.log(shaders.vertexShader_glow);

	// ===============================================
	// Set up the WebGL renderer

	var SCREEN_WIDTH = window.innerWidth
	var SCREEN_HEIGHT = window.innerHeight;
	var VIEW_ANGLE = 45;
	var ASPECT = SCREEN_WIDTH/SCREEN_HEIGHT;
	var ASPECT = 16/9;
	var NEAR = 0.1;
	var FAR = 20000;

	renderer = new THREE.WebGLRenderer(
		{
			antialias: true,
			autoClearColor: true,
			alpha: true,
			premultipliedAlpha: false
		}
	);
	renderer.setClearColor(0x000000, 0);
	
	// ===============================================
	// Automatically set the viewport to 16/9 and add borders if needed.
	resize_window();
	window.onresize = function(){
		resize_window();
	};
	//THREEx.FullScreen.bindKey({ charCode : 'f'.charCodeAt(0) });

	container = document.getElementById("container");
	container.appendChild(renderer.domElement);


	// ===============================================
	// Add FPS stats

	if(!demoMode) {
		stats = new Stats();
		stats.domElement.style.position = 'absolute';
		stats.domElement.style.bottom = '0px';
		stats.domElement.style.zIndex = 100;
		container.appendChild( stats.domElement );	
	} else {
		$("#demotime").hide();
	}
	

	// ===============================================
	// Load the final pass post-processing shader
	load_final_pass_shader();

	effectcomposer = new THREE.EffectComposer(renderer);

	// ===============================================
	// Initialize full screen texture buffers
	buffer1 = new THREE.WebGLRenderTarget( wBufferWidth, wBufferHeight, {
		minFilter: THREE.LinearFilter,
		magFilter: THREE.NearestFilter,
		format: THREE.RGBAFormat
	});

	buffer2 = new THREE.WebGLRenderTarget( wBufferWidth, wBufferHeight, {
		minFilter: THREE.LinearFilter,
		magFilter: THREE.NearestFilter,
		format: THREE.RGBAFormat
	});

	buffer3 = new THREE.WebGLRenderTarget( wBufferWidth, wBufferHeight, {
		minFilter: THREE.LinearFilter,
		magFilter: THREE.NearestFilter,
		format: THREE.RGBAFormat
	});

	buffer4 = new THREE.WebGLRenderTarget( wBufferWidth, wBufferHeight, {
		minFilter: THREE.LinearFilter,
		magFilter: THREE.NearestFilter,
		format: THREE.RGBAFormat
	});

	buffer5 = new THREE.WebGLRenderTarget( wBufferWidth, wBufferHeight, {
		minFilter: THREE.LinearFilter,
		magFilter: THREE.NearestFilter,
		format: THREE.RGBAFormat
	});

	buffer6 = new THREE.WebGLRenderTarget( wBufferWidth, wBufferHeight, {
		minFilter: THREE.LinearFilter,
		magFilter: THREE.NearestFilter,
		format: THREE.RGBAFormat
	});



	// ===============================================
	// Load the scenes

	scenes.title_screen = new scene_titlescreen();
	scenes.title_screen.load();

	scenes.globe = new scene_globe();
	scenes.globe.load();
	
	scenes.tunnel = new scene_tunnel();
	scenes.tunnel.load();

	scenes.microscope = new scene_microscope();
	scenes.microscope.load();

	scenes.terrain = new scene_terrain();
	scenes.terrain.load();

	scenes.textparticles = new scene_textparticles();
	scenes.textparticles.load("aurora");

	scenes.staticNoise = new scene_staticnoise();
	scenes.staticNoise.load();
	
	scenes.raymarching = new scene_raymarching();
	scenes.raymarching.load(shaders.fragmentShader_raymarching);
	
	scenes.raymarching2 = new scene_raymarching();
	scenes.raymarching2.load(shaders.fragmentShader_raymarching2);

	scenes.boxworm = new scene_boxworm();
	scenes.boxworm.load();

	// ===============================================
	// Define display sequence.
	//load_timeline(); // from timeline.js

	lineup_rockets(); // from launchpad.js

	// add(scene objekt, scene funksjon, duration, {transition effects});

/*
	scene_composer.add(scenes.globe, scenes.globe.slow_zoom_to_earth, 17, {in: ['black', 7], out: ['black', 1],});

	scene_composer.add(scenes.globe, scenes.globe.render_test2, 1, {in: ['black', 0.2], out: ['black', 0.2],});
	scene_composer.add(scenes.globe, scenes.globe.zoom_into_earth, 3, {in: ['black', 0.5], out: ['black', 0.2],});
	scene_composer.add(scenes.globe, scenes.globe.zoom_into_earth, 3, {in: ['black', 0.5], out: ['black', 0.5],});
	scene_composer.add(scenes.globe, scenes.globe.zoom_into_earth, 3, {in: ['black', 0.5], out: ['black', 0.5],});
	scene_composer.add(scenes.globe, scenes.globe.render_test2, 1);
	scene_composer.add(scenes.globe, scenes.globe.zoom_into_earth, 3);
*/
	//scene_composer.add(scenes.globe, scenes.globe.render_test2, 5);	
	//scene_composer.add(scenes.globe, scenes.globe.orbit1, 10);
	//scene_composer.add(scenes.globe, scenes.globe.render_test2, 5);	
	//scene_composer.add(scenes.globe, scenes.globe.orbit1, 10);

	//scene_composer.add(scenes.globe, scenes.globe.render_test2, 1);
	//scene_composer.add(scenes.globe, scenes.globe.render_test, 3);
	//scene_composer.add(scenes.globe, scenes.globe.render_test2, 4);
	

	// Prep the composer
	//scene_composer.prepare();

	// Prepare to load megatextures into GPU memory
	prepare_texture_preloader();

	// Wait for loading to complete, and start renderloop.
	//renderwait();
	preload_texture();

	

	//prepareSync();
}

function preload_scenes() {
	row = 0;
	demo_time = row / ROW_RATE;
	final_pass.uniforms['fadeToBlack'].value = 1.0;

	for(var i = 0; i < launchpad.scenes.length; i++) {
		loading_console_write("Preloading scene " + i + "...");
		launchpad.launch(i);
	}

	loading_console_write('All done!');
	destroy_loading_console();

	prepareSync();
}

// Sync Step 1
function prepareSync() {
	loading_console_write("Loading timings from rocket...");

	if (demoMode) {
		syncDevice.setConfig({'rocketXML':'demo.rocket'});
		syncDevice.init("demo");
	} else {
		//_syncDevice.setConfig({'socketURL':'ws://192.168.0.100:1338'});
		syncDevice.init();
	}

	syncDevice.on('ready', onSyncReady);
	syncDevice.on('update', onSyncUpdate);
	syncDevice.on('play', onPlay);
	syncDevice.on('pause', onPause);
}

// Sync Step 2, called when "ready" event of syncDevice runs
function onSyncReady() {
	for (var key in rocketTracks) {
		if (rocketTracks.hasOwnProperty(key)) {
			rocketTracks[key] = syncDevice.getTrack(key);
		}
	}

	prepareAudio();
}

// Sync step 3
function prepareAudio() 
{
	loading_console_write("Loading music");

	_audio.src = 'sfx/epic-dubstep-uncut.ogg';
	_audio.addEventListener('canplay', onAudioReady);
	_audio.preload = true;
	_audio.muted = !demoMode;
	_audio.load();
}

// Sync step 4, called by "canplay" event of _audio
function onAudioReady() 
{
	if(demoMode) { 
		_audio.play();
	} else {
		_audio.pause();
		_audio.currentTime = (row / ROW_RATE);
	}
	render();
}

// Called when you move around in rocket 
function onSyncUpdate(newRow){

	// newRow is empty if you are just changing stuff in rocket
	if (!isNaN(newRow)) {
		row = newRow;
	}

	//console.log("[onSyncUpdate] time in seconds", row / ROW_RATE);

	//update your view
	render();
}

// Called by rocket when you press play. Seeks the audio and starts playing it
function onPlay() {
	_audio.currentTime = (row / ROW_RATE);
    _audio.play();
	//console.log("[onPlay] time in seconds", row / ROW_RATE);
    render();
}

// Called by rocket when you press pause. Stores current time from audio and cancel render requests.
function onPause(){
	row = _audio.currentTime * ROW_RATE;
	window.cancelAnimationFrame(render, document);
	_audio.pause();
}

function render()
{
	// If the audio is playing we update the current row location based on the audio time
	if(_audio.paused === false) {
		//otherwise we may jump into a point in the audio where there's
		//no timeframe, resulting in Rocket setting row 2 and we report
		//row 1 back - thus Rocket spasming out
		row = _audio.currentTime * ROW_RATE;

		// this informs Rocket where we are
		syncDevice.update(row);
	}

	// Calculates demotime based on the row selected in rocket
	demo_time = row / ROW_RATE;

	document.getElementById('demotime').innerHTML = demo_time.toFixed(3);

	final_pass.uniforms['demoTime'].value = demo_time;
	final_pass.uniforms['fadeToBlack'].value = getVal("fadeToBlack"); // rocketTracks.fadeToBlack.getValue(row);
	final_pass.uniforms['lens'].value = getVal("lens");
	final_pass.uniforms['rgbShift'].value = getVal("rgbshift")/1000.0;
	final_pass.uniforms['vignette'].value = getVal("vignette")/100.0;
	final_pass.uniforms['scanlines'].value = getVal("scanlines")/100.0;

	final_pass.uniforms['grain'].value = getVal("grain");

	//_audio.volume = getVal("var7");

	// FPS counter
	if(!demoMode) {
		stats.update();	
	}
	

	
	// Requests the next frame after 1/60 sec from browser if we are playing or in demo mode
	if((demoMode === true)  || (_audio.paused === false))
		window.requestAnimationFrame(render, document);
	else
		window.cancelAnimationFrame(render, document);
	//renderer.render(scene, camera);
	

	//window.requestAnimationFrame(render, document);

	// ===============================================
	// Vise riktig scene til rett tid.
	//scene_composer.play(demo_time);

	// ===============================================
	// Playground for debugging scenes

	//scenes.globe.render_test(demo_time);
	//scenes.globe.orbit_test(demo_time);
	//scenes.terrain.render_test(demo_time);
	//scenes.globe.inside_earth(demo_time);
	//scenes.globe.aurora_test(demo_time,0);
	//scenes.globe.descend(demo_time,0);

	//scenes.tunnel.render(demo_time);

	launchpad.launch(rocketTracks.scene.getValue(row));
}

function renderwait()
{
	console.log("Renderwait...");
	if (loadable_elements>loaded_elements)
	{
		setTimeout(function(){ renderwait() },100);
	} else
	{
		destroy_loading_console();
		render();
	}
}

function resize_window()
{
	// Window is too high
	if (window.innerWidth/window.innerHeight <= 16/9)
	{
		var width = window.innerWidth;
		var height = Math.floor(width/16*9);
		var top = Math.floor((window.innerHeight-height)/2);
		var left = 0;

	// Window is too wide
	} else
	{
		var height = window.innerHeight;
		var width = Math.floor(height/9*16);
		var top = 0;
		var left = Math.floor((window.innerWidth-width)/2);
	}

	document.getElementById('container').style.top = top+'px';
	document.getElementById('container').style.left = left+'px';
	document.getElementById('container').style.width = width+'px';
	document.getElementById('container').style.height = height+'px';

	renderer.setSize(width, height);

	wWidth = width;
	wHeight = height;
	/*
	if (wWidth > 1920)
	{
		wBufferWidth = 1920;
		console.log("using max buffer width of 1920");
	} else
	{
		wBufferWidth = wWidth;
	}

	if (wHeight > 1080)
	{
		wBufferHeight = 1080;
		console.log("using max buffer height of 1080");
	} else
	{
		wBufferHeight = wHeight;
	}
	*/
	wBufferWidth = wWidth;
	wBufferHeight = wHeight;
}


function morph (x1, x2, factor)
{
	if (x1<x2)
	{
		return (x1+(x2-x1)*factor);
	} else
	{
		return (x1-(x1-x2)*factor);
	}
}

function smoothstep (min, max, value) {
  var x = Math.max(0, Math.min(1, (value-min)/(max-min)));
  return x*x*(3 - 2*x);
};