THREE.StaticPass = function (opacity) {

	this.opacity = opacity;

	this.uniforms = {
		"tDiffuse": { "type": "t", "value": null },
		"opacity": { "type": "f", "value": 1.0 },
		"time": { "type": "f", "value": 0.0 },
		"size": { "type": "v2", "value": new THREE.Vector2(320, 160) }
	}

	this.material = new THREE.ShaderMaterial({
		uniforms: this.uniforms,
		vertexShader: shaders.vertexShader_generic,
		fragmentShader: shaders.fragmentShader_staticnoise
	});

	this.enabled = true;
	this.renderToScreen = false;
	this.needsSwap = true;

	this.camera = new THREE.OrthographicCamera( -1, 1, 1, -1, 0, 1 );
	this.scene  = new THREE.Scene();

	this.quad = new THREE.Mesh( new THREE.PlaneGeometry( 2, 2 ), null );
	this.scene.add( this.quad );

};

THREE.StaticPass.prototype = {

	setTime: function (t) {
		this.uniforms["time"].value = t;
	},

	setSize: function (v) {
		this.uniforms["size"].value = v;
	},

	render: function ( renderer, writeBuffer, readBuffer, delta ) {

		this.uniforms[ "tDiffuse" ].value = readBuffer;
		this.uniforms[ "opacity" ].value = this.opacity;

		this.quad.material = this.material;

		if ( this.renderToScreen ) {

			renderer.render( this.scene, this.camera );

		} else {

			renderer.render( this.scene, this.camera, writeBuffer, false );

		}

	}

};