/**
 * based on shader by zz85 / http://www.lab4games.net/zz85/blog
 *
 * - "h" and "v" parameters should be set to "1 / width" and "1 / height"
 */

THREE.MassiveVerticalBlurShader = {

	uniforms: {

		"tDiffuse": { type: "t", value: null },
		"v":        { type: "f", value: 1.0 / 512.0 }

	},

	vertexShader: [

		"varying vec2 vUv;",

		"void main() {",

			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",

		"}"

	].join("\n"),

	fragmentShader: [

		"uniform sampler2D tDiffuse;",
		"uniform float v;",
		"const int samples = 100;",
		"const float s = 1.2 / float(samples);",

		"varying vec2 vUv;",

		"void main() {",

			"vec4 sum = vec4( 0.0 );",
			"vec4 sample;",

			"sum += texture2D(tDiffuse, vUv) * (s * 2.0);",
			"for(int i = 1; i <= samples; i++) {",
				"float imp = mix(s, 0.0, float(i) / float(samples));",

				"sample = texture2D( tDiffuse, vec2( vUv.x, vUv.y - (float(i) * v) ) );",
				"sum += vec4(sample.r) * imp;",

				"sample = texture2D( tDiffuse, vec2( vUv.x, vUv.y + (float(i) * v) ) );",
				"sum += vec4(sample.r) * imp;",
			"}",

			"gl_FragColor = clamp(sum, 0.0, 1.0);",

		"}"

	].join("\n")

};
