#!/usr/bin/env python

import sys
import getopt
import signal
import thread
import random
from random import shuffle
from ai import AI

ip = "127.0.0.1"
port = 54321
nick = "#trending"

spam = [
	"#YOLO",
	"#happybirthdayjustinbieber",
	"#easter",
	"#selfie",
	"#bryrmegikkeborioslo",
	"#tgwtf",
	"#random",
	"#ARNE",
	"#vaskhendene",
	"#snap",
	"#putinYOLO",
	"#YOLOL",
	"#bart",
	"#ikkefortvilNeymar",
	"#svenskehandel",
	"#pantsOff",
	"#nudeSnap",
	"#fjordland",
	"#svette"
]

def signal_handler(signal, frame):
	sys.exit(0)

def arguments(argv):
	global ip, port, nick

	try:
		opts, args = getopt.getopt(argv,"hdi:p:n:",["ip=","port=","nick="])
	except getopt.GetoptError:
		print "./bot.py -i <ip> -p <port> -n <nick>"
		sys.exit(1)
	for opt, arg in opts:
		if opt in ("-h", "--help"):
			print "./bot.py -i <ip> -p <port> -n <nick>"
			sys.exit()
		elif opt in ("-i", "--ip"):
			ip = arg
		elif opt in ("-p", "--port"):
			port = arg
		elif opt in ("-n", "--nick"):
			nick = arg
		elif opt in ("-d", "--debug"):
			print "DEBUG MODE"
			ai.debug = True

if __name__ == "__main__":
	signal.signal(signal.SIGINT, signal_handler)
	ai = AI()
	arguments(sys.argv[1:])
	ai.connect(ip, port)
	ai.name(nick)
	ai.setJSON()
	print "Waiting for game to start!"
	ai.update()

	if ai.debug:
		try:
			thread.start_new_thread(ai.viz,())
		except:
			print "Error: unable to start viz thread!"

	sweetSpot = 0

	while True:
		ai.update()

		if ai.gamestate == "playing":

			if not ai.isSafe(ai.px, ai.py, 5):
				ai.notSafe()

			if ai.suddenDeath and random.random() < 0.1:
				# center magic
				mx = int(ai.width/2)
				my = int(ai.height/2)
				ai.score[my][mx] = ai.score[my][mx] + 1
				ai.scoreWalk()
			elif not ai.bombDropped and ai.bombValue(ai.px,ai.py) >= 1 and not ai.suddenDeath: # and random.random() < 0.5:
				ai.dropBomb()
			elif sweetSpot >= 5 and not ai.suddenDeath:
				print "Booring... MOVE!"
				ai.score[ai.py][ai.px] = -3
				#ai.randomWalk()
				ai.scoreWalk()
			elif not ai.bombDropped and not ai.suddenDeath:
				ai.scoreWalk()
			else:
				if random.random() < 0.05:
					ai.say(spam[random.randint(0,len(spam)-1)])
				elif random.random() < 0.1:
					ai.randomWalk()
				
			'''
				#ai.scoreWalk()
			elif not ai.suddenDeath:
				bv = ai.bombValue(ai.px,ai.py)
				#print "bomb value:", bv
				newDrop = False
				if bv >= 3 and not ai.bombDropped:
					newDrop = ai.dropBomb()
				if not newDrop and not ai.scoreWalk() and ai.bombValue(ai.px,ai.py) >= 1 and not ai.bombDropped:
					ai.dropBomb()
				else:
					if random.random() < 0.05:
						ai.say(spam[random.randint(0,len(spam)-1)])
					elif random.random() < 0.1:
						ai.randomWalk()

					#ai.randomWalk()
					#ai.scoreWalk()
			'''

			if ai.oldPx == ai.px and ai.oldPy == ai.py:
				sweetSpot += 1
			else:
				sweetSpot = 0

			if ai.Bombs[ai.by][ai.bx] == ".":
				ai.bombDropped = False

		# eor or dead
		else:
			ai.suddenDeath = False
			sweetSpot = 0
			if ai.debug:
				ai.debugPrint()
