import collections 
from math import sqrt

# set up a Coord named tuple that we can use to store coordinates. Also adds support for adding and subtracting Coord instances.
Coord = collections.namedtuple("Coord", "x y")
def coordAddSupport(self, other):
    return Coord(x=self.x+other.x, y=self.y+other.y)

def coordSubSupport(self, other):
    return Coord(x=self.x-other.x, y=self.y-other.y)    

def coordToString(self):
    return "x={0},y={1}".format(self.x, self.y)

def coordEquals(self, other):
    if other == None:
        return False
    return self.x == other.x and self.y == other.y

def coordDistance(self, other):
    return sqrt((other.x - self.x)**2 + (other.y - self.y)**2)

def coordNeighbours(self):
	return [self - Coord(x=1, y=0), self - Coord(x=-1, y=0), self - Coord(x=0, y=1), self - Coord(x=0, y=-1)]

Coord.__add__ = coordAddSupport
Coord.__sub__ = coordSubSupport
Coord.__str__ = coordToString
Coord.__repr__ = coordToString
Coord.__eq__ = coordEquals
Coord.distance = coordDistance
Coord.neighbours = coordNeighbours
