import logging
logger = logging.getLogger(__name__)
from coord import Coord
import socket
import pprint
import json
import datetime

class GameConnector(object):
    handler_mapdata = None
    handler_ownposition = None
    handler_enemylist = None
    handler_commandrequest = None
    handler_bomblist = None
    handler_endround = None
    handler_dead = None

    sock = None
    ownName = None
    mapSize = Coord(x=0, y=0)
    inputbuf = ""

    def __init__(self, ownName):
        self.ownName = ownName

    def connect(self, host, port):
        self.sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        try:
            self.sock.settimeout(0.02)
            self.sock.connect((host, port))
            self.sendLine("JSON")
            self.sendLine("NAME " + self.ownName)
        except socket.error as e:
            pprint.pprint(e)
            exit()

    def readPacket(self):
        try:
            self.inputbuf += self.sock.recv(1)
        except socket.timeout as s_timout:
            logger.error(s_timout)
        except socket.error as s_error:
            logger.error(s_error)
            return None

        try:
            characters_to_read = self.inputbuf.index("\n")
            line = self.inputbuf[0:characters_to_read]  # removing the newline
            self.inputbuf = self.inputbuf[characters_to_read + 1:len(self.inputbuf)]
            return line
        except ValueError as f:
            logger.error(f)
            return None

    def parseJSONPacket(self, packet):
        print "Get JSON data: {0}".format(packet["type"])

        if packet["type"] == "dead":
            self.handler_dead()

        if packet["type"] == "round end":
            self.handler_endround()

        if packet["type"] == "status update":
            self.handler_ownposition( Coord(x=int(packet["x"]), y=int(packet["y"])) )
            self.handler_bomblist( packet["bombs"] )
            self.handler_enemylist( packet["players"] )
            self.handler_mapdata( Coord(x=int(packet["width"]), y=int(packet["height"])) , packet["map"] )

            a = datetime.datetime.now()
            cmd = self.handler_commandrequest()
            b = datetime.datetime.now()

            timeused = (b - a).microseconds / 1000
            if timeused < 80:
                print "Command request took: {0} ms".format(timeused)
            else:
                print "OUT OF SYNC!!!!!!!!!!! SPENT {0} ms".format(timeused)
                while self.readPacket() != None:
                    print "Threw away some data..."
                    pass

            if cmd != None:
                self.sendLine(cmd)

    def parseLine(self, line):
        # print "SERVER: |{0}|".format(line)

        try:
            line = line.replace("} {", "}, {")
            packet = json.loads(line)
        except ValueError as e:
            print("Error decoding JSON packet: {0}\nJSON: {1}".format(e, line))
        except AttributeError as e:
            print("Invalid message: %s" % e)
        else:
            self.parseJSONPacket(packet)

    def sendLine(self, line):
        self.previous_message = line
        print "CLIENT: |{0}|".format(line)

        if self.sock.sendall(line + "\n") is not None:
            print("Error sending data!")

    def parsingLoop(self):
        try:        
            while True:
                line = self.readPacket()

                if line != None:
                    self.parseLine(line)

        except KeyboardInterrupt:
            print "OK, I'm quitting!"
            exit()
            # except Exception as e:
            # pprint.pprint(e)