from astar import AStar, AStarNode
from math import sqrt

class AStarGrid(AStar):
    def heuristic(self, node, start, end):
        return sqrt((end.x - node.x)**2 + (end.y - node.y)**2)

class AStarGridNode(AStarNode):
    def __init__(self, x, y, tile, isPlayer, isDeadly):
        self.x, self.y = x, y
        self.tile = tile
        self.isPlayer = isPlayer
        self.isDeadly = isDeadly
        super(AStarGridNode, self).__init__()

    def move_cost(self, other):
        if other.tile == "#":
            return 14
        if other.isPlayer:
            return 20
        if other.isDeadly:
            return 100
        return 1

    def __repr__(self):
        return "{0}x{1}".format(self.x, self.y)

    def __str__(self):
        return "{0}x{1}".format(self.x, self.y)
