﻿using System.Collections.Generic;
using System.Linq;

namespace segfault {
   class State : Pos {
      public const int _BombTicksTilBoom = 6;
      public List<Player> Players;
      public List<Bomb> Bombs;
      public int W, H;
      public byte[,] Map;

      public void InitMap() {
         Map = new byte[W, H];
      }

      public int Generation { get; private set; }

      public bool Contains(Pos p) {
         return p.X > -1 && p.Y > -1 && p.X < W && p.Y < H;
      }

      public State(int generation) {
         Generation = generation;
         Players = new List<Player>();
         Bombs = new List<Bomb>();
      }

      public override string ToString() {
         return Map.Mappify();
      }

      public bool IsPassable(byte[][,] Fut, Pos p, int ticksFromNow) {
         return
            Fut[(1 + Generation + ticksFromNow) % Fut.Length].At(p) == TILE.Grass
            && Fut[(2 + Generation + ticksFromNow) % Fut.Length].At(p) == TILE.Grass // only needed sometimes, who fails here?
            && !Players.Any(q => q.SamePos(p));
      }

      public Step[,] Study(byte[][,] Fut, Pos from, int maxDist = 33) {
         var dist = new Step[W, H];

         var open = new Stack<Step>();
         var start = new Step(from);
         open.Push(start);
         dist.SetAt(from, start);

         while (open.Any()) {
            var p = open.Pop();
            for (int dir = 0; dir < 4; dir++) {
               var next = new Step(p.Offset((Dir)dir), p);
               if (next.Distance > maxDist || next.X < 0 || next.Y < 0 || next.X >= W || next.Y >= H)
                  continue;
               if (IsPassable(Fut, next, next.Distance)) {
                  var curr = dist.At(next);
                  if (curr == null || curr.Distance > next.Distance) {
                     open.Push(next);
                     dist.SetAt(next, next);
                  }
               }
            }
         }
         return dist;
      }
   }
}
