#!/usr/bin/perl

use strict;
use warnings;

#use Devel::SimpleTrace;

use Time::HiRes 'sleep';

use AI;

use AI::Pathfinding::AStar::Rectangle 'create_map';

print 'Server IP and port: ';
my $server = <STDIN>;
chomp $server;
#my $server = '127.0.0.1:54321';

print 'My name: ';
my $name = <STDIN>;
chomp $name;
#my $name = 'Test';

# Variables! \o/
my ($astar, $last_x, $last_y, $stuck);

my $ai = AI->new(
    'server' => $server
);

$ai->bind('MAP', sub {
    return if defined $astar;

    $astar = create_map({
        'width' => $ai->{'map_width'},
        'height' => $ai->{'map_height'}
    });

    $astar->foreach_xy_set(sub {
        no warnings 'once';
        return substr(${$ai->{'map'}}[$b], $a, 1) =~ /[#\.]/;
    });
});

$ai->bind('OK', sub {
    #print "\n";

    my $map = {};

    foreach my $y (0 .. $ai->{'map_height'} - 1) {
        foreach my $x (0 .. $ai->{'map_width'} - 1) {
            $map->{$y} = {} unless defined $map->{$y};
            $map->{$y}->{$x} = substr ${$ai->{'map'}}[$y], $x, 1;
        }
    }

    foreach my $player (@{$ai->{'players'}}) {
        my ($pid, $px, $py) = split(/[ ,]/, $player, 3);

        # Tiles with players are not walkable.
        # Do this before placing bombs, as it is more important to know if
        # a bomb is about to blow us up, than it is to know where some dude
        # is standing.
        $map->{$py}->{$px} = 'X';
    }

    foreach my $bomb (@{$ai->{'bombs'}}) {
        my ($bomb_x, $bomb_y, $fuse) = split(/[ ,]/, $bomb, 3);

        # Eye of the storm.
        $map->{$bomb_y}->{$bomb_x} = $fuse;

        # Left.
        foreach my $danger_x (reverse $bomb_x - 2 .. $bomb_x - 1) {
            # Outside the map.
            last if $danger_x < 0 or
                    $danger_x > $ai->{'map_width'} - 1;

            # Wall.
            last if $map->{$bomb_y}->{$danger_x} eq '#' or
                    $map->{$bomb_y}->{$danger_x} eq '+';

            $map->{$bomb_y}->{$danger_x} = $fuse;
        }

        # Right.
        foreach my $danger_x ($bomb_x + 1 .. $bomb_x + 2) {
            # Outside the map.
            last if $danger_x < 0 or
                    $danger_x > $ai->{'map_width'} - 1;

            # Wall.
            last if $map->{$bomb_y}->{$danger_x} eq '#' or
                    $map->{$bomb_y}->{$danger_x} eq '+';

            $map->{$bomb_y}->{$danger_x} = $fuse;
        }

        # Up.
        foreach my $danger_y (reverse $bomb_y - 2 .. $bomb_y - 1) {
            # Outside the map.
            last if $danger_y < 0 or
                    $danger_y > $ai->{'map_height'} - 1;

            # Wall.
            last if $map->{$danger_y}->{$bomb_x} eq '#' or
                    $map->{$danger_y}->{$bomb_x} eq '+';

            $map->{$danger_y}->{$bomb_x} = $fuse;
        }

        # Down.
        foreach my $danger_y ($bomb_y + 1 .. $bomb_y + 2) {
            # Outside the map.
            last if $danger_y < 0 or
                    $danger_y > $ai->{'map_height'} - 1;

            # Wall.
            last if $map->{$danger_y}->{$bomb_x} eq '#' or
                    $map->{$danger_y}->{$bomb_x} eq '+';

            $map->{$danger_y}->{$bomb_x} = $fuse;
        }
    }

    my $path;

    # Are we in danger?
    if ($map->{$ai->{'y'}}->{$ai->{'x'}} =~ /[0-5]/) {
        #print 'In danger!' . "\n";

        #$ai->say($map->{$ai->{'y'}}->{$ai->{'x'}});

        # Get the fuck out of there!
        foreach my $y (0 .. $ai->{'map_height'} - 1) {
            foreach my $x (0 .. $ai->{'map_width'} - 1) {
                next unless $map->{$y}->{$x} eq '.';

                my $test_path = $astar->astar(
                    $ai->{'x'},
                    $ai->{'y'},
                    $x,
                    $y
                );

                next unless defined $test_path && length $test_path;

                my $step = substr $test_path, 0, 1;

                # Verify that the path is open.
                if ($step == 1) {
                    # Down left.
                    next if $map->{$ai->{'y'} + 1}->{$ai->{'x'}} =~ /[\+#]/ &&
                            $map->{$ai->{'y'}}->{$ai->{'x'} - 1} =~ /[\+#]/;
                } elsif ($step == 2) {
                    # Down.
                    next if $map->{$ai->{'y'} + 1}->{$ai->{'x'}} =~ /[\+#]/;
                } elsif ($step == 3) {
                    # Down right.
                    next if $map->{$ai->{'y'} + 1}->{$ai->{'x'}} =~ /[\+#]/ &&
                            $map->{$ai->{'y'}}->{$ai->{'x'} + 1} =~ /[\+#]/;
                } elsif ($step == 4) {
                    # Left.
                    next if $map->{$ai->{'y'}}->{$ai->{'x'} - 1} =~ /[\+#]/;
                } elsif ($step == 6) {
                    # Right.
                    next if $map->{$ai->{'y'}}->{$ai->{'x'} + 1} =~ /[\+#]/;
                } elsif ($step == 7) {
                    # Up left.
                    next if $map->{$ai->{'y'} - 1}->{$ai->{'x'}} =~ /[\+#]/ &&
                            $map->{$ai->{'y'}}->{$ai->{'x'} - 1} =~ /[\+#]/;
                } elsif ($step == 8) {
                    # Up.
                    next if $map->{$ai->{'y'} - 1}->{$ai->{'x'}} =~ /[\+#]/;
                } elsif ($step == 9) {
                    # Up right.
                    next if $map->{$ai->{'y'} - 1}->{$ai->{'x'}} =~ /[\+#]/ &&
                            $map->{$ai->{'y'}}->{$ai->{'x'} + 1} =~ /[\+#]/;
                }

                $path = $test_path if !defined $path || length $test_path < length $path;
            }
        }
    }

    # Check if we're stuck, unless we're already heading somewhere else.
    if ((!defined $path || !length $path) && (defined $last_x && defined $last_y) && ($ai->{'x'} == $last_x && $ai->{'y'} == $last_y) && ++$stuck >= 3 + int rand 3) {
        #print 'Stuck!' . "\n";

        # It appears we are. Try to blast our way through!
        $ai->bomb();

        $stuck = 0;
        return;
    }

    # Remember where we were.
    $last_x = $ai->{'x'};
    $last_y = $ai->{'y'};

    # Are we going somewhere?
    if (!defined $path || !length $path) {
        #print 'Stalking...' . "\n";

        # No. Find a path to the nearest player.
        $path = '5' x 9999;
        foreach my $player (@{$ai->{'players'}}) {
            my ($pid, $player_x, $player_y) = split(/[ ,]/, $player, 3);

            #$map->{$player_y}->{$player_x} = 'X';

            my $test_path = $astar->astar(
                $ai->{'x'},
                $ai->{'y'},
                $player_x,
                $player_y
            );

            my $step = substr $test_path, 0, 1;

            # Verify that the path is open.
            if ($step == 1) {
                # Down left.
                next if $map->{$ai->{'y'} + 1}->{$ai->{'x'}} eq '+' &&
                        $map->{$ai->{'y'}}->{$ai->{'x'} - 1} eq '+';
            } elsif ($step == 3) {
                # Down right.
                next if $map->{$ai->{'y'} + 1}->{$ai->{'x'}} eq '+' &&
                        $map->{$ai->{'y'}}->{$ai->{'x'} + 1} eq '+';
            } elsif ($step == 7) {
                # Up left.
                next if $map->{$ai->{'y'} - 1}->{$ai->{'x'}} eq '+' &&
                        $map->{$ai->{'y'}}->{$ai->{'x'} - 1} eq '+';
            } elsif ($step == 9) {
                # Up right.
                next if $map->{$ai->{'y'} - 1}->{$ai->{'x'}} eq '+' &&
                        $map->{$ai->{'y'}}->{$ai->{'x'} + 1} eq '+';
            }

            $path = $test_path if length $test_path < length $path;
        }
    }

    # Follow the path.
    if (defined $path && length $path) {
        my $step = substr $path, 0, 1;

        # NOOP. Do something random.
        $step = 1 + int(rand 9) if $step == 5;

        #print 'Stepping ' . $step . '...' . "\n";

        if ($step == 1) {
            # Down left.
            if ($map->{$ai->{'y'} + 1}->{$ai->{'x'}} =~ /[\.2-5]/) {
                $ai->down();
            } elsif ($map->{$ai->{'y'}}->{$ai->{'x'} - 1} !~ /[01]/) {
                $ai->left();
            }
        } elsif ($step == 2) {
            # Down.
            $ai->down() unless $map->{$ai->{'y'} + 1}->{$ai->{'x'}} =~ /[01]/;
        } elsif ($step == 3) {
            # Down right.
            if ($map->{$ai->{'y'} + 1}->{$ai->{'x'}} =~ /[\.2-5]/) {
                $ai->down();
            } elsif ($map->{$ai->{'y'}}->{$ai->{'x'} + 1} !~ /[01]/) {
                $ai->right();
            }
        } elsif ($step == 4) {
            # Left.
            $ai->left() unless $map->{$ai->{'y'}}->{$ai->{'x'} - 1} =~ /[01]/;
        } elsif ($step == 6) {
            # Right.
            $ai->right() unless $map->{$ai->{'y'}}->{$ai->{'x'} + 1} =~ /[01]/;
        } elsif ($step == 7) {
            # Up left.
            if ($map->{$ai->{'y'} - 1}->{$ai->{'x'}} =~ /[\.2-5]/) {
                $ai->up();
            } elsif ($map->{$ai->{'y'}}->{$ai->{'x'} - 1} !~ /[01]/) {
                $ai->left();
            }
        } elsif ($step == 8) {
            # Up.
            $ai->up() unless $map->{$ai->{'y'} - 1}->{$ai->{'x'}} =~ /[01]/;
        } elsif ($step == 9) {
            # Up right.
            if ($map->{$ai->{'y'} - 1}->{$ai->{'x'}} =~ /[\.2-5]/) {
                $ai->up();
            } elsif ($map->{$ai->{'y'}}->{$ai->{'x'} + 1} !~ /[01]/) {
                $ai->right();
            }
        }
    }
});

$ai->bind('DEAD', sub {
    undef $astar;

    $ai->say('Good heavens!');
});

$ai->bind('ENDOFROUND', sub {
    undef $astar;

    $ai->say('gg');
});

# For shits and giggles.
$SIG{'INT'} = sub {
    $ai->say('Aaah!');
    undef $ai;
    die 'Received SIGINT!';
};

$ai->connect();

$ai->set_name($name);

$ai->tick() while sleep 0.001;

exit;
