﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Windows.Forms;

namespace lilfireBass
{



    public partial class Form1 : Form
    {
        private  List<List<MapElement>> _map;
        private  List<Player> _players;
        private  List<Bomb> _bombs;
        private  List<Moves> _plannedMoves;
        private  NetworkStream _nwStream;
        private Point _myPos;
        private List<Point> _myMoves; 
        private string _say = "lilfire";

        public Form1()
        {
            InitializeComponent();
        }

        private void StartAi(object sender, DoWorkEventArgs doWorkEventArgs)
        {
            var client = new TcpClient(doWorkEventArgs.Argument.ToString(), 54321);
            _nwStream = client.GetStream();
            byte[] bytesToSend = Encoding.ASCII.GetBytes("NAME lilfire\n");

            _nwStream.Write(bytesToSend, 0, bytesToSend.Length);

            var reader = new StreamReader(_nwStream);

            _players = new List<Player>();
            _bombs = new List<Bomb>();
            _map = new List<List<MapElement>>();
            _plannedMoves = new List<Moves>();
            _myMoves = new List<Point>();

            while (client.Connected)
            {
                string line;
                while ((line = reader.ReadLine()) != null)
                {
                    ReadDataFromServer(line, reader);
                    if (line.Equals("MAP"))
                        DoShit();
                }
            }
        }
        
        static readonly Random Rnd = new Random();

        private void DoShit()
        {
            if (_map.Count == 0)
                return;

            if (_plannedMoves.Any())
            {
                if (ValidMove(_plannedMoves[0]) && IsSafe(_plannedMoves[0]))
                {

                    ExecuteMove(_plannedMoves[0]);
                    _plannedMoves.RemoveAt(0);
                }
                else
                {
                    _plannedMoves.Clear();
                    DoShit();
                }
            }
            else
            {

                var possibleFirstMoves = PossibleSafeMoves(_myPos);
                if (!IsSafe(_myPos))
                    Move(possibleFirstMoves);
                else
                {
                    if (!_bombs.Any(b => b.Mine))
                    {
                        var possibleMoves = ShouldPlaceBomb(possibleFirstMoves).ToList(); 
                        
                        var highImpactMove = possibleMoves.Where(move => move.First().Affect > 1.0).ToList();
                        if (highImpactMove.Any())
                        {
                            var bestEscape = highImpactMove.First();
                            foreach (var possibleMove in highImpactMove)
                                if (possibleMove.First().Affect > bestEscape.First().Affect)
                                    bestEscape = possibleMove;
                            
                            _plannedMoves.AddRange(bestEscape.Select(m => m.Move.Value));
                            PlaceBomb();
                            return;   
                            
                        }
                        if (possibleMoves.Any())
                        {
//                            _plannedMoves.AddRange(possibleMoves.First().Select(m => m.Move.Value));
//                            PlaceBomb();
//                            return;   
                        }
                    }
                    
                    if (possibleFirstMoves.Any())
                        Move(possibleFirstMoves);
                    else
                    {
                        _say = "";
                        Say();
                    }
                }
            }
        }

        private MapElement GetMapElement(Moves move)
        {
            if (move == Moves.Down)
                return GetElementAt(_myPos.X, _myPos.Y + 1);

            if (move == Moves.Up)
                return GetElementAt(_myPos.X, _myPos.Y - 1);

            if (move == Moves.Left)
                return GetElementAt(_myPos.X - 1, _myPos.Y);

            if (move == Moves.Right)
                return GetElementAt(_myPos.X + 1, _myPos.Y);

            return null;
        }

        private void Move(List<PossibleMove> possibleFirstMoves)
        {
            var mypos = GetElementAt(_myPos);
            var emptySurroundingElements = GetEmptySurroundingElements(mypos);


            MapElement lastPos = null;
            if (_myMoves.Count >= 2)
                lastPos =
                    emptySurroundingElements.FirstOrDefault(
                        me => me.X == _myMoves[_myMoves.Count - 2].X && me.Y == _myMoves[_myMoves.Count - 2].Y);

            if (lastPos != null)
                emptySurroundingElements.Remove(lastPos);

            if (emptySurroundingElements.Any())
            {
                var bestElements = BestElements(emptySurroundingElements);

//                        if (bestElement == mypos)
//                            MoveTo(possibleFirstMoves.ElementAt(Rnd.Next(possibleFirstMoves.Count)).Move.Value);
//                        else
                var element = Rnd.Next(bestElements.Count);
                GoTo(new Point(bestElements[element].X, bestElements[element].Y));
            }
            else if (lastPos != null)
                GoTo(new Point(lastPos.X, lastPos.Y));
            else if (possibleFirstMoves.Any())
                MoveTo(possibleFirstMoves.ElementAt(Rnd.Next(possibleFirstMoves.Count)).Move.Value);
            else
            {
                _say = "";
                Say();
            }
        }


        private List<MapElement> BestElements(List<MapElement> emptySurroundingElements)
        {
            var bestElements = new List<MapElement>();
            bestElements.Add(emptySurroundingElements.First());

            foreach (var mapElement in emptySurroundingElements)
            {
                if (mapElement.Impact > bestElements.First().Impact)
                {
                    MapElement fromElement;
                    MapElement toElement;

                    Astar(new Point(mapElement.X, mapElement.Y), _myPos);
                    GetMove(mapElement, out fromElement, out toElement);

                    if (fromElement == null || toElement == null)
                    {
                        continue;
                    }

                    if (_myMoves.Count >= 2 && (toElement.X != _myMoves[_myMoves.Count - 2].X || toElement.Y != _myMoves[_myMoves.Count - 2].Y))
                    {
                        bestElements.Clear();
                        bestElements.Add(mapElement);
                    }
                }
                else if (mapElement.Impact == bestElements.First().Impact)
                {
                    MapElement fromElement;
                    MapElement toElement;

                    Astar(new Point(mapElement.X, mapElement.Y), _myPos);
                    GetMove(mapElement, out fromElement, out toElement);

                    if (fromElement == null || toElement == null)
                    {
                        continue;
                    }

                    if (_myMoves.Count >= 2 && (toElement.X != _myMoves[_myMoves.Count - 2].X || toElement.Y != _myMoves[_myMoves.Count - 2].Y))
                    {
                        bestElements.Add(mapElement);
                    }
                }
            }
            return bestElements;
        }

        private bool ValidMove(Moves plannedMove)
        {
            if (plannedMove == Moves.Down)
                return GetElementAt(_myPos.X, _myPos.Y + 1) is Empty;

            if (plannedMove == Moves.Up)
                return GetElementAt(_myPos.X, _myPos.Y - 1) is Empty;

            if (plannedMove == Moves.Left)
                return GetElementAt(_myPos.X -1, _myPos.Y) is Empty;

            if (plannedMove == Moves.Right)
                return GetElementAt(_myPos.X + 1, _myPos.Y) is Empty;

            return false;
        }


        private void ExecuteMove(Moves plannedMove)
        {
            if (plannedMove == Moves.Bomb)
                PlaceBomb();
            else if (plannedMove == Moves.Say)
                Say();
            else if (ValidMove(plannedMove))
                MoveTo(plannedMove);
            else
            {
                _say = "Usikker";
                Say();
            }
        }

        private IEnumerable<List<PossibleMove>> ShouldPlaceBomb(IEnumerable<PossibleMove> possibleFirstMoves)
        {
            //if (_map.Any(row => row.Any(me => me is Rock)))
            {
                var possibleMoves = new List<List<PossibleMove>>();
                Console.WriteLine(_myPos.X + @" " + _myPos.Y);
                foreach (var possibleFirstMove in possibleFirstMoves)
                {
                    
                    var possibleSecondMoves = PossibleSafeMoves(possibleFirstMove.Move.Key.X, possibleFirstMove.Move.Key.Y, 2);


                    var secondMoves = new List<PossibleMove>();
                    foreach (var possibleSecondMove in possibleSecondMoves)
                    {
                        if (possibleSecondMove.Move.Key.X != _myPos.X || possibleSecondMove.Move.Key.Y != _myPos.Y)
                            secondMoves.Add(possibleSecondMove);
                    }


                    
                    //secondMoves = possibleSecondMoves.Where(m => m.Move.Key.X != _myPos.X && m.Move.Key.Y != _myPos.Y).ToList();
                    if(secondMoves.Any()){
                        foreach (var possibleSecondMove in secondMoves)
                        {
                            if (!IsSafe(possibleSecondMove.Move.Key.X, possibleSecondMove.Move.Key.Y, 3) || !IsSafe(possibleSecondMove.Move.Key.X, possibleSecondMove.Move.Key.Y, 4) || !IsSafe(possibleSecondMove.Move.Key.X, possibleSecondMove.Move.Key.Y, 5))
                                continue;

                            GetEscapeAndBombAffect(possibleMoves, new List<KeyValuePair<MapElement,Moves>>
                            {
                                possibleFirstMove.Move,
                                possibleSecondMove.Move
                            });
                        }
                        return possibleMoves;
                    }
                    foreach (var possibleSecondMove in secondMoves)
                    {
                        var possibleThirdMoves = PossibleSafeMoves(possibleSecondMove.Move.Key.X, possibleSecondMove.Move.Key.Y, 3);
                        
                        foreach (var possibleThirdMove in possibleThirdMoves)
                        {
                            GetEscapeAndBombAffect(possibleMoves, new List<KeyValuePair<MapElement, Moves>>
                            {
                                possibleFirstMove.Move,
                                possibleSecondMove.Move,
                                possibleThirdMove.Move
                            });
                        }
                    }
                }
            }
//            else
//            {
//                //sudden death
//            }
            return new List<List<PossibleMove>>();
        }


        public List<MapElement> GetEmptySurroundingElements(MapElement element, MapElement startElement = null, List<MapElement> elements = null)
        {
            if(elements == null)
                elements = new List<MapElement>();

            

            foreach (var mapElement in PossibleMoves(element.X, element.Y).Select(pm => pm.Key).Where(me => me != startElement))
                if (!elements.Contains(mapElement))
                {
                    elements.Add(mapElement);
                    GetEmptySurroundingElements(mapElement, element, elements);
                }
                    


            return elements;
        } 

        private void GetEscapeAndBombAffect(List<List<PossibleMove>> possibleEscapeMoves, List<KeyValuePair<MapElement, Moves>> possibleMoves)
        {
            var possibleMove = new List<PossibleMove>();
            possibleMove.AddRange(possibleMoves.Select(move => new PossibleMove {Move = move}));


            foreach (var player in _players)
            {
                var element = Astar(new Point(possibleMoves.Last().Key.X, possibleMoves.Last().Key.Y), new Point(player.X, player.Y));
                if (player.X != element.X && player.Y != element.Y)
                    if (element.G <= 2)
                    {
                        possibleMove.First().Affect -= 3;
                    }
            }


            var affectedMapElements = GetBombAffectedMapElements(_myPos);

            var affectedRocks = affectedMapElements.Where(me => me is Rock).Count();
            var affectedPlayers = affectedMapElements.Where(me => me is Player).Count();
            var affect = affectedRocks + (affectedPlayers*0.5);
            foreach (var player in _players)
            {
                foreach (var affectedMapElement in affectedMapElements)
                {
                    var element = Astar(new Point(affectedMapElement.X, affectedMapElement.Y), new Point(player.X, player.Y));
                    if (player.X != element.X && player.Y != element.Y)
                        if (element.G <= 5)
                            affect += 0.5;
                }
            }

            possibleMove.First().Affect += affect;

            possibleEscapeMoves.Add(possibleMove);
        }

        private void GoTo(Point toPoint)
        {
            var target = Astar(toPoint, _myPos);

            if (target == GetElementAt(_myPos))
            {
                _say = "";
                ExecuteMove(Moves.Say);
                return;
            }


            MapElement fromElement;
            MapElement toElement;
            GetMove(target, out fromElement, out toElement);

            if((fromElement == null || toElement == null) || !IsSafe(toElement.X, toElement.Y))
            {
                _say = "A* error";
                Say();
                return;
            }

//            if(toElement.X ==_myMoves[_myMoves.Count-2].X && toElement.Y ==_myMoves[_myMoves.Count-2].Y)
//            {
//                
//            }
//            
            var dx = toElement.X - fromElement.X;

            if (dx == -1)
                ExecuteMove(Moves.Left);
            else if (dx == 1)
                ExecuteMove(Moves.Right);
            else if (dx == 0)
            {
                var dY = toElement.Y - fromElement.Y;

                if (dY == -1)
                    ExecuteMove(Moves.Up);
                else if (dY == 1)
                    ExecuteMove (Moves.Down);
            }
            else
            {
                _say = "Jeg prøver på noe som ikke er gyldig";
                ExecuteMove(Moves.Say);    
            }
            
        }

        private void GetMove(MapElement target, out MapElement fromElement, out MapElement toElement)
        {
            var moves = new List<MapElement> {target};
            if (target.Parent == null || target.Parent.Parent == target)
            {
                fromElement = null;
                toElement = null;
                return;
            }
            
            while (target.Parent != null)
            {
                target = target.Parent;
                moves.Insert(0, target);
            }

            toElement = moves[1];
            fromElement = moves[0];
            
        }

        private MapElement Astar(Point toPoint, Point fromPoint)
        {
            ClearParent();

            var open = new List<MapElement>();
            var closed = new List<MapElement>();

            var startElement = GetElementAt(fromPoint);
            var endElement = GetElementAt(toPoint);
            startElement.G = 0;
            startElement.H = 0;
            open.Add(startElement);

            while (open.Any())
            {
                var q = MinF(open);
                open.Remove(q);
                closed.Add(q);
                foreach (var mapElement in PossibleSafeMoves(q.X, q.Y, q.G + 1).Select(pm => pm.Move).Select(m => m.Key).Where(me => !closed.Contains(me)))
                {
                        
                    var element = open.FirstOrDefault(me => me.X == mapElement.X && me.Y == mapElement.Y);

                    if (element != null && element.F < mapElement.F)
                        continue;

                    if(q.Parent == mapElement)
                    {
                        
                    }
                    else
                        mapElement.Parent = q;
                    mapElement.G = q.G + 1;
                    mapElement.H =
                        (int) Math.Sqrt(Math.Pow((startElement.X - toPoint.X), 2) +
                                        Math.Pow((startElement.Y - toPoint.Y), 2));

                    if (mapElement == endElement)
                        return endElement;

                    if (element == null)
                        open.Add(mapElement);
                }
            }
            return startElement;
        }

        private void ClearParent()
        {
            foreach (var row in _map)
            {
                foreach (var mapElement in row)
                {
                    mapElement.Parent = null;
                }
            }
        }

        private MapElement MinF(List<MapElement> open)
        {
            var me = open.First();

            foreach (var mapElement in open)
            {
                if (mapElement.F < me.F)
                    me = mapElement;
            }
            return me;
        }

        public class LilPath
        {
            public List<Moves> Moves { get; set; }
            public int Distance { get; set; }

            public LilPath()
            {
                Moves = new List<Moves>();
            }
        }

        private List<MapElement> GetBombAffectedMapElements(Point bomb)
        {
            var element = GetElementAt(bomb);

            if (element is Bomb)
                return GetBombAffectedMapElements((Bomb)element);

            return GetBombAffectedMapElements(new Bomb {X = bomb.X, Y = bomb.Y, Tick = 5});
        }

        private List<MapElement> GetBombAffectedMapElements(Bomb bomb)
        {
            var elements = new List<MapElement> {bomb};

            var mapElement = GetElementAt(bomb.X - 1, bomb.Y);
            if(!(mapElement is OutSide) && !(mapElement is Obstruction))
            {
                elements.Add(mapElement);
                if (mapElement is Empty || mapElement is Player)
                    elements.Add(GetElementAt(bomb.X - 2, bomb.Y));
                else if (mapElement is Bomb && ((Bomb)mapElement).Tick > bomb.Tick)
                    elements.AddRange(GetBombAffectedMapElements((Bomb)mapElement));
            }

            mapElement = GetElementAt(bomb.X + 1, bomb.Y);
            if (!(mapElement is OutSide) && !(mapElement is Obstruction))
            {
                elements.Add(mapElement);
                if (mapElement is Empty || mapElement is Player)
                    elements.Add(GetElementAt(bomb.X + 2, bomb.Y));
                else if (mapElement is Bomb && ((Bomb) mapElement).Tick > bomb.Tick)
                    elements.AddRange(GetBombAffectedMapElements((Bomb) mapElement));
            }

            mapElement = GetElementAt(bomb.X, bomb.Y - 1);
            if (!(mapElement is OutSide) && !(mapElement is Obstruction))
            {
                elements.Add(mapElement);
                if (mapElement is Empty || mapElement is Player)
                    elements.Add(GetElementAt(bomb.X, bomb.Y - 2));
                else if (mapElement is Bomb && ((Bomb) mapElement).Tick > bomb.Tick)
                    elements.AddRange(GetBombAffectedMapElements((Bomb) mapElement));
            }

            mapElement = GetElementAt(bomb.X, bomb.Y + 1);
            if (!(mapElement is OutSide) && !(mapElement is Obstruction))
            {
                elements.Add(mapElement);
                if (mapElement is Empty || mapElement is Player)
                    elements.Add(GetElementAt(bomb.X, bomb.Y + 2));
                else if (mapElement is Bomb && ((Bomb) mapElement).Tick > bomb.Tick)
                    elements.AddRange(GetBombAffectedMapElements((Bomb) mapElement));
            }

            return elements;
        }

        private List<PossibleMove> PossibleSafeMoves(Point point, int turn = 1)
        {
            return PossibleSafeMoves(point.X, point.Y, turn);
        }

        private List<PossibleMove> PossibleSafeMoves(int x, int y, int turn = 1)
        {
            var moves = new List<PossibleMove>();

            var mapElement = GetElementAt(x, y - 1);
            if (mapElement is Empty && IsSafe(x, y - 1, turn))
                moves.Add(new PossibleMove {Move = new KeyValuePair<MapElement, Moves>(mapElement, Moves.Up)});
            mapElement = GetElementAt(x, y + 1);
            if (mapElement is Empty && IsSafe(x, y + 1, turn))
                moves.Add(new PossibleMove {Move = new KeyValuePair<MapElement, Moves> (mapElement, Moves.Down)});
            mapElement = GetElementAt(x + 1, y);
            if (mapElement is Empty && IsSafe(x + 1, y, turn))
                moves.Add(new PossibleMove {Move = new KeyValuePair<MapElement, Moves> (mapElement, Moves.Right)});
            mapElement = GetElementAt(x - 1, y);
            if (mapElement is Empty && IsSafe(x - 1, y, turn))
                moves.Add(new PossibleMove {Move = new KeyValuePair<MapElement, Moves> (mapElement, Moves.Left)});

            return moves;
        }

        private Dictionary<MapElement, Moves> PossibleMoves(Point point)
        {
            return PossibleMoves(point.X, point.Y);
        }



        private Dictionary<MapElement, Moves> PossibleMoves(int x, int y)
        {
            var moves = new Dictionary<MapElement, Moves>();

            var mapElement = GetElementAt(x, y - 1);
            if (mapElement is Empty) moves[mapElement] = Moves.Up;
            mapElement = GetElementAt(x, y + 1);
            if (mapElement is Empty) moves[mapElement] = Moves.Down;
            mapElement = GetElementAt(x + 1, y);
            if (mapElement is Empty) moves[mapElement] = Moves.Right;
            mapElement = GetElementAt(x - 1, y);
            if (mapElement is Empty) moves[mapElement] = Moves.Left;

            return moves;
        }


        private bool IsSafe(Moves plannedMove)
        {
            if (plannedMove == Moves.Down)
                return IsSafe(_myPos.X, _myPos.Y + 1);

            if (plannedMove == Moves.Up)
                return IsSafe(_myPos.X, _myPos.Y - 1);

            if (plannedMove == Moves.Left)
                return IsSafe(_myPos.X - 1, _myPos.Y);

            if (plannedMove == Moves.Right)
                return IsSafe(_myPos.X + 1, _myPos.Y);

            return false;
        }

        private bool IsSafe(int x, int y, int turn = 1)
        {
            return IsSafe(new Point(x, y), turn);
        }

        private bool IsSafe(Point point, int turn = 1)
        {
            if (_bombs.Where(b => b.Tick == turn || b.Tick == turn+1).Any(bomb => GetBombAffectedMapElements(bomb).Any(
                bombAffectedMapElement =>
                bombAffectedMapElement.X == point.X && bombAffectedMapElement.Y == point.Y)))
            {
                return false;
            }

            var dangerElemens = new List<MapElement>();

            var possibleMoves = PossibleMoves(point);
            possibleMoves.Add(GetElementAt(point), Moves.Say);
            foreach (var element in possibleMoves)
            {
                if (_bombs.Where(b => b.Tick == turn+1 || b.Tick == turn +2).Any(bomb => GetBombAffectedMapElements(bomb).Any(
                    bame =>
                    (bame.X == element.Key.X && bame.Y == element.Key.Y))))
                {
                    dangerElemens.Add(element.Key);
                }

                if (!dangerElemens.Contains(element.Key))
                {
                    //Console.WriteLine("trygt: " +point.X + " " + point.Y);
                    return true;
                }
                    
            }


            return false;
        }

        private void Say()
        {
            _nwStream.Write(Encoding.ASCII.GetBytes("SAY " + _say + "\n"), 0, Encoding.ASCII.GetBytes("SAY " + _say + "\n").Length);            
        }

        private void PlaceBomb()
        {
            _nwStream.Write(Encoding.ASCII.GetBytes("BOMB\n"), 0, Encoding.ASCII.GetBytes("BOMB\n").Length);
            _bombs.Add(new Bomb { X = _myPos.X, Y = _myPos.Y, Mine = true });
        }

        private void MoveTo(Moves moves)
        {
            switch (moves)
            {
                case Moves.Left:
                    _nwStream.Write(Encoding.ASCII.GetBytes("LEFT\n"), 0, Encoding.ASCII.GetBytes("LEFT\n").Length);
                    break;
                case Moves.Right:
                    _nwStream.Write(Encoding.ASCII.GetBytes("RIGHT\n"), 0, Encoding.ASCII.GetBytes("RIGHT\n").Length);
                    break;
                case Moves.Up:
                    _nwStream.Write(Encoding.ASCII.GetBytes("UP\n"), 0, Encoding.ASCII.GetBytes("UP\n").Length);
                    break;
                case Moves.Down:
                    _nwStream.Write(Encoding.ASCII.GetBytes("DOWN\n"), 0, Encoding.ASCII.GetBytes("DOWN\n").Length);
                    break;
            }
        }

        private void ReadDataFromServer(string line, StreamReader reader)
        {
            var serverData = new List<string> {line};

            //players
            if (line.Equals("PLAYERS"))
            {
                //_players.Clear();
                while ((line = reader.ReadLine()) != null)
                {
                    serverData.Add(line);
                    if (!line.Equals("ENDPLAYERS"))
                    {
                        int id;
                        int.TryParse(line.Substring(0, line.IndexOf(" ")), out id);
                        int x;
                        int.TryParse(line.Substring(line.IndexOf(" "), line.IndexOf(",") - 1), out x);
                        int y;
                        int.TryParse(line.Substring(line.IndexOf(",") + 1), out y);

                        var player = _players.FirstOrDefault(p => p.Id.Equals(id));

                        if(player == null)
                        {
                            player = new Player{Id = id, X = x, Y = y};
                            player.Moves.Add(new Point(x,y));
                            _players.Add(player);
                        }
                        else
                        {
                            player.Moves.Add(new Point(x,y));
                            player.X = x;
                            player.Y = y;
                        }
                    }
                    else
                        break;
                }
            }


                //bombs
            else if (line.Equals("BOMBS"))
            {
                var mineBomb = _bombs.FirstOrDefault(b => b.Mine);
                _bombs.Clear();
                int x;
                int y;
                while ((line = reader.ReadLine()) != null)
                {
                    serverData.Add(line);
                    if (!line.Equals("ENDBOMBS"))
                    {
                        int.TryParse(line.Substring(0, line.IndexOf(",")), out x);
                        int.TryParse(line.Substring(line.IndexOf(",") + 1, line.IndexOf(" ") - (line.IndexOf(",") + 1)), out y);

                        int tick;
                        int.TryParse(line.Substring(line.IndexOf(" ")), out tick);

                        _bombs.Add(new Bomb
                                       {
                                           X = x,
                                           Y = y,
                                           Tick = tick,
                                           Mine = mineBomb != null && mineBomb.X == x && mineBomb.Y == y
                                       });
                    }
                    else
                    {
                        break;
                    }
                }

                //my pos
                line = reader.ReadLine() ?? string.Empty;
                serverData.Add(line);
                int.TryParse(line.Substring(line.IndexOf(" ")), out x);

                line = reader.ReadLine() ?? string.Empty;
                serverData.Add(line);
                int.TryParse(line.Substring(line.IndexOf(" ")), out y);

                _myPos = new Point(x, y);
                _myMoves.Add(_myPos);

                //map size
                line = reader.ReadLine() ?? string.Empty;
                serverData.Add(line);
                int height;
                int.TryParse(line.Substring(line.IndexOf(" ")), out height);

                line = reader.ReadLine() ?? string.Empty;
                serverData.Add(line);
                int width;
                int.TryParse(line.Substring(line.IndexOf(" ")), out width);
            }


                //map

            else if (line.Equals("MAP"))
            {
                _map.Clear();
                while ((line = reader.ReadLine()) != null)
                {
                    serverData.Add(line);
                    var row = new List<MapElement>();
                    _map.Add(row);
                    if (!line.Equals("ENDMAP"))
                    {
                        foreach (var c in line)
                        {
                            switch (c)
                            {
                                case '#':
                                    row.Add(new Rock());
                                    break;
                                case '+':
                                    row.Add(new Obstruction());
                                    break;
                                case '.':
                                    row.Add(new Empty());
                                    break;
                            }
                        }
                    }
                    else
                    {
                        //insert player
                        foreach (var player in _players)
                            SetElementAt(player.X, player.Y, player);

                        //insert bomb
                        foreach (var bomb in _bombs)
                            SetElementAt(bomb.X, bomb.Y, bomb);

                        //vektlegg tomme felter
                        for (int y = 0; y < _map.Count; y++)
                        {
                            var mapRow = _map[y];
                            for (int x = 0; x < mapRow.Count; x++)
                            {
                                var mapElement = mapRow[x];
                                var element = GetElementAt(x + 1, y);
                                if (element is Rock)
                                    mapElement.Impact += 1;
                                else if (element is Player)
                                    mapElement.Impact += 2;
                                else if (element is Bomb)
                                    mapElement.Impact += ((Bomb)element).Tick -5;

                                element = GetElementAt(x - 1, y);
                                if (element is Rock)
                                    mapElement.Impact += 1;
                                else if (element is Player)
                                    mapElement.Impact += 2;
                                else if (element is Bomb)
                                    mapElement.Impact += ((Bomb)element).Tick - 5;

                                element = GetElementAt(x, y + 1);
                                if (element is Rock)
                                    mapElement.Impact += 1;
                                else if (element is Player)
                                    mapElement.Impact += 2;
                                else if (element is Bomb)
                                    mapElement.Impact += ((Bomb)element).Tick - 5;


                                element = GetElementAt(x, y - 1);
                                if (element is Rock)
                                    mapElement.Impact += 1;
                                else if (element is Player)
                                    mapElement.Impact += 2;
                                else if (element is Bomb)
                                    mapElement.Impact += ((Bomb)element).Tick - 5;

                            }
                        }

                        break;
                    }
                }
            }

//            foreach (var serverDataLine in serverData)
//            {
//                Console.WriteLine(serverDataLine);
//            }
        }

        private MapElement GetElementAt(int x, int y)
        {
            if (y >= _map.Count || y < 0)
                return new OutSide();
            
            var row = _map.ElementAt(y);

            if (x >= row.Count || x < 0)
                return new OutSide();

            var mapElement = row.ElementAt(x);

            if (mapElement != null && mapElement.X != x)
                mapElement.X = x;

            if (mapElement != null && mapElement.Y != y)
                mapElement.Y = y;

            return mapElement;
        }

        private MapElement GetElementAt(Point point)
        {
            return GetElementAt(point.X, point.Y);
        }

        private void SetElementAt(int x, int y, MapElement element)
        {
            _map[y][x] = element;
        }

        private void BtnStartClick(object sender, EventArgs e)
        {
            var bw = new BackgroundWorker();
            bw.DoWork += StartAi;
            bw.RunWorkerAsync(ip.Text);
        }
    }

    public class MapElement 
    {
        public int X { get; set; }
        public int Y { get; set; }
        public int Impact { get; set; }

        public MapElement Parent { get; set; }
        public int H { get; set; }
        public int G { get; set; }
        public int F { get { return G + H; } }
    }

    public class Bomb : MapElement
    {
        public int Tick { get; set; }
        public bool Mine { get; set; }
    }

    public class Rock : MapElement{}
    public class Empty : MapElement { }
    public class Obstruction : MapElement { }
    public class OutSide : MapElement { }
    public class Player : MapElement
    {
        public List<Point> Moves { get; set; } 
        public int Id { get; set; }

        public Player()
        {
            Moves = new List<Point>();
        }
    }

    public class PossibleMove
    {
        public KeyValuePair<MapElement, Moves> Move { get; set; }
        public double Affect { get; set; }
    }

    public enum Moves
    {
        Left,
        Right,
        Up,
        Down,
        Bomb,
        Say
    }
}


