#include "OdinAI/EventManager.h"
#include "OdinAI/Event.h"
#include "OdinAI/Timer.h"

#include <iostream>
namespace OdinAI
{
	void EventManager::AddEventListener(const char* eventName, EventCallback callBackFunction, void *pOwner)
	{
        EventListener listener = {callBackFunction, pOwner};
        m_eventListeners[eventName].push_back(listener);
	}
	
	void EventManager::FireEvent(std::shared_ptr<Event> event, uint delay)
	{
		if (delay == 0)
		{
			for(auto it = m_eventListeners[event->GetName()].begin();
                it != m_eventListeners[event->GetName()].end();++it)
            {
                it->callback(static_cast<const Event*>(event.get()));
            }
		}
		else
		{
			uint currentTime = Timer::GetGlobalMillisec<uint>();
			EventRecord evtRec = {event, delay, currentTime};
			m_eventStore.push_back(evtRec);
		}
	}

    void EventManager::RemoveEventListener(const char *eventName, EventCallback callback, void *pOwner)
    {
        auto &listeners = m_eventListeners[eventName]; 
        for(auto it = listeners.begin();
            it != listeners.end();++it)
        {
            if(it->pOwner == pOwner &&
               it->callback.target_type() == callback.target_type())
            {
                it = listeners.erase(it);
                break;
            }
        }
    }

	void EventManager::Update()
	{
		for (auto iter = m_eventStore.begin();iter != m_eventStore.end();++iter)
		{
			if ((Timer::GetGlobalMillisec<uint>() - iter->sent >= iter->delay))
			{
				for(auto &listener : m_eventListeners[iter->event->GetName()])
				{
                    listener.callback(static_cast<const Event*>(iter->event.get()));
				}

				iter = m_eventStore.erase(iter);
				if(iter == m_eventStore.end())
				{
					break;
				}
			}
		}
	}

    void EventManager::Release()
    {
        m_eventStore.clear();
	}
}
