#include "Evaluators.h"
#include "Player.h"

bool IsBomb(char code)
{
    return code < 32 || code == static_cast<char>(Tile::Bomb);
}

double BombRiskEval::Desireability() const
{
    const iVec2 &currentPos = m_pPlayer->GetPosition();
    
    // Early out test.
    if(IsBomb(m_map[currentPos.x][currentPos.y]))
    {
        // Run, fire in the hole!
        return 100.0;
    }

    // TODO: make an advanced analyze algorithm.
    return 0.0;
}