#include "AttackGoal.h"
#include "BombGoal.h"
#include "MoveToGoal.h"
#include "Player.h"
#include "GameManager.h"

void AttackGoal::Activate()
{
    m_status = OdinAI::GOAL_ACTIVE;

    char tilesAroundTarget[4];
    const Player *pPlayer = gGameMgr.GetPlayerMgr().GetPlayer(m_targetID);
    const iVec2 &targetPos = pPlayer->GetPosition();
    m_target = targetPos;

    const auto &map = gGameMgr.GetMap().GetMap();
    tilesAroundTarget[0] = map[targetPos.x-1][targetPos.y];
    tilesAroundTarget[1] = map[targetPos.x+1][targetPos.y];
    tilesAroundTarget[2] = map[targetPos.x][targetPos.y-1];
    tilesAroundTarget[3] = map[targetPos.x][targetPos.y+1];

    iVec2 finalTarget = iVec2(0, 0);
    for(int i = 0;i < 4;++i)
    {
        if(gGameMgr.GetMap().IsTileStandAble(tilesAroundTarget[i]) || tilesAroundTarget[i] < 32)
        {
            finalTarget.x = i <= 1 ? targetPos.x + ((i*2) - 1) : targetPos.x;
            finalTarget.y = i > 1 ? targetPos.y + ((i-2)*2 - 1) : targetPos.y;
            break;
        }
    }

    AddGoal(new MoveToGoal(m_pOwner, finalTarget));
}

int AttackGoal::Process()
{
    const Player *pPlayer = gGameMgr.GetPlayerMgr().GetPlayer(m_targetID);

    if(pPlayer->IsDead())
    {
        m_status = OdinAI::GOAL_COMPLETE;
        return m_status;
    }

    ActivateIfInactive();

    if ((m_pOwner->GetPosition().y == pPlayer->GetPosition().y && std::abs(m_pOwner->GetPosition().x - pPlayer->GetPosition().x) <= 2) ||
        (m_pOwner->GetPosition().x == pPlayer->GetPosition().x && std::abs(m_pOwner->GetPosition().y - pPlayer->GetPosition().y) <= 2))
    {
        Clear();
        AddGoal(new BombGoal(m_pOwner));
    }
    else if(m_target != pPlayer->GetPosition())
    {
        Clear();
        Activate();
    }

    m_status = ProcessSubgoals();

    return m_status;
}

void AttackGoal::End()
{

}