#ifndef DNB_THINK_GOAL_H_
#define DNB_THINK_GOAL_H_

#include "OdinAI/Goals.h"

class Player;

/**
 * Main goal, which evaluates goals, and choose the the best one.
 */
class ThinkGoal : public OdinAI::CompositeGoal
{
public:
    ThinkGoal(Player *pOwner) : m_pOwner(pOwner), m_isFleeing(false) {}

    /**
     * Function called before a goal is processed.
     */
    void Activate();

    /**
     * Function used to process an goal.
     */
    int Process();

    /**
     * Function used to clean up an goal.
     */
    void End();
private:
    Player *m_pOwner;//!< Pointer to the owner.

    bool m_isFleeing;
};

#endif