#ifndef DNB_MOVE_TO_GOAL_H_
#define DNB_MOVE_TO_GOAL_H_

#include "OdinAI/Goals.h"
#include "OdinAI/Event.h"
#include "Vector2.h"
#include "GameManager.h"
#include <list>

class Player;
/**
 * Goal used to move to a position.
 * It will destroy blocks if it is necessary.
 */
class MoveToGoal : public OdinAI::CompositeGoal
{
public:
    MoveToGoal(Player *pOwner, const iVec2 &target) : m_pOwner(pOwner), m_target(target) 
    {
        gGameMgr.GetEventMgr().AddEventListener("mapChanged", std::bind(&MoveToGoal::OnMapChanged, this, std::placeholders::_1), this);
    }

    /**
     * Function called before a goal is processed.
     */
    void Activate();

    /**
     * Function used to process goal.
     */
    int Process();

    /**
     * Function used to clean up an goal.
     */
    void End();

    /**
     * Set target, to move towards.
     */
    void SetTarget(const iVec2 &target);

    /**
     * @return The current target position.
     */
    const iVec2 &GetTarget() const;

    void OnMapChanged(const OdinAI::Event *pEvent);
private:
    iVec2 m_target;
    Player *m_pOwner;
};

#endif