#ifndef DNB_HEURISTIC_FUNCTION_H_
#define DNB_HEURISTIC_FUNCTION_H_

#include "OdinAI/MathUtil.h"

class ManhattanFunction
{
public:
    template <class GRAPH_TYPE>
    static int Calculate(const GRAPH_TYPE &graph, int nodeA, int nodeB)
    {
        return std::abs(graph.GetNode(nodeA).GetPosition().x - graph.GetNode(nodeB).GetPosition().x) + 
               std::abs(graph.GetNode(nodeA).GetPosition().y - graph.GetNode(nodeB).GetPosition().y);
    }
};

#endif