#ifndef DNB_FLEE_POSITION_GOAL_H_
#define DNB_FLEE_POSITION_GOAL_H_

#include "OdinAI/Goals.h"
#include "OdinAI/Event.h"
#include <list>
#include <vector>
#include "GameManager.h"

class Player;
class Map;

class FleeToSafePos : public OdinAI::CompositeGoal
{
public:
    FleeToSafePos(Player *pOwner, const std::vector< std::vector<char> > &map) : m_pOwner(pOwner), m_map(map)
    {
        gGameMgr.GetEventMgr().AddEventListener("mapChanged", std::bind(&FleeToSafePos::OnMapChanged, this, std::placeholders::_1), this);
    }

    /**
     * Function called before a goal is processed.
     */
    void Activate();

    /**
     * Function used to process an goal.
     */
    int Process();

    /**
     * Function used to clean up an goal.
     */
    void End();
 
 private:
    void OnMapChanged(const OdinAI::Event *pEvent);

    std::list<int> Search(int minRange);

    std::vector< std::vector<char> > m_map;
    Player *m_pOwner;
};

#endif