#ifndef DNB_BOMB_H_
#define DNB_BOMB_H_

#include "Vector2.h"
#include <vector>

class GameManager;

struct Bomb
{
    iVec2 position; // Bomb position.
    int gameTicks; // Number of game ticks, until the bomb explodes.
};

/**
 * @brief Bomb manager class handles all the bombs that have been dropped.
 */
class BombManager
{
public:
    /**
     * @return Our bombs.
     */
    const std::vector<Bomb> &GetBombs() const;

    /**
     * Fill a map with the bombs and explosion radius.
     * The cells are filled with the number of ticks left, before the bomb explodes.
     * It will only fill parts that are standable.
     * 
     * The bombs that are more than 32 ticks away from exploding is not added.
     */
    void FillMap(std::vector< std::vector<char> > *map) const;

    /**
     * Clear the bomb manager.
     */
    void Clear();
private:
    void FillArea(std::vector< std::vector<char> > *map, const iVec2 &pos, int tick) const;

    std::vector<Bomb> m_bombs;

    friend GameManager;
};

#endif