#ifndef DNB_ATTACK_GOAL_H_
#define DNB_ATTACK_GOAL_H
#include "OdinAI/Goals.h"
#include "Player.h"
/**
 * @brief Attacks target
 */
class AttackGoal : public OdinAI::CompositeGoal
{
public:
    AttackGoal(Player *pOwner, int targetID) : m_pOwner(pOwner), m_targetID(targetID), m_target(0, 0) {}

    /**
    * Function called before a goal is processed.
    */
    void Activate();

    /**
    * Function used to process goal.
    */
    int Process();

    /**
    * Function used to clean up an goal.
    */
    void End();
private:
    int m_targetID;
    Player *m_pOwner;
    iVec2 m_target;
};
#endif