/*
 * Decompiled with CFR 0.152.
 */
package tg2014;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Queue;
import tg2014.GameData;

public class Main {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        try {
            Socket client = new Socket(args[0], 54321);
            PrintStream ps = new PrintStream(client.getOutputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(client.getInputStream()));
            ps.println("NAME Chilli\n");
            ps.print("SAY Game on, bitches!\n");
            String s = br.readLine();
            String[] packet = new String[64];
            GameData data = new GameData();
            int i = 0;
            boolean exit = false;
            while (true) {
                if (exit) {
                    client.close();
                    System.exit(0);
                    return;
                }
                while ((s = br.readLine()) != null) {
                    if (s.equals("PLAYERS")) {
                        i = 0;
                    } else if (s.equals("ENDOFROUND\n")) {
                        if (!data.dead) {
                            ps.print("SAY Go home, bitches!\n");
                        }
                        data.queue.clear();
                        data.activeBombs = 0;
                        data.activePlayers = 0;
                        data.dead = false;
                    } else if (s.equals("DEAD\n")) {
                        data.dead = true;
                        ps.print("SAY Good game!\n");
                    } else if (s.equals("ENDMAP")) {
                        data.updateData(packet);
                        data.prioritizeSearchOrder();
                        if (!Main.inSafeSpot(data)) {
                            data.queue.clear();
                            data.queue.addAll(Main.calculateSafeSpot(data));
                        }
                        if (data.queue.size() > 0) {
                            ps.print(data.queue.poll().comand);
                        } else if (Main.getSurroundingBombThreats(data) + Main.getSurroundingWalls(data) != 4) {
                            data.queue.addAll(Main.calculateBombPlacement(data));
                        }
                        if (data.activeBombs <= data.activePlayers + 1) break;
                        ps.print("SAY I was made for this!\n");
                        break;
                    }
                    packet[i] = s;
                    ++i;
                }
                if (client.isConnected() && !client.isClosed()) continue;
                exit = true;
            }
        }
        catch (UnknownHostException e) {
            System.exit(0);
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            System.exit(0);
            e.printStackTrace();
        }
    }

    private static boolean getWallAtPosition(GameData data, int x, int y) {
        if (y < data.map.length && y >= 0 && x < data.map[y].length && x >= 0) {
            int i = 0;
            while (i < data.activeBombs) {
                if (data.bombs[i][0] == x && data.bombs[i][1] == y) {
                    return true;
                }
                ++i;
            }
            return data.map[y][x] != '.';
        }
        return false;
    }

    private static int getSurroundingWalls(GameData data) {
        return Main.getSurroundingWallsAtPosition(data, data.playerX, data.playerY);
    }

    private static int getSurroundingWallsAtPosition(GameData data, int x, int y) {
        int nr = 0;
        int i = 0;
        while (i < 4) {
            if (Main.getWallAtPosition(data, x + data.searchOrder[i][0], y + data.searchOrder[i][1])) {
                ++nr;
            }
            ++i;
        }
        return nr;
    }

    private static boolean getBombThreatAtPosition(GameData data, int x, int y) {
        if (y < data.bombMap.length && y >= 0 && x < data.bombMap[y].length && x >= 0) {
            return data.bombMap[y][x] == 'B';
        }
        return false;
    }

    private static int getSurroundingBombThreats(GameData data) {
        return Main.getSurroundingBombThreatsAtPosition(data, data.playerX, data.playerY);
    }

    private static int getSurroundingBombThreatsAtPosition(GameData data, int x, int y) {
        int nr = 0;
        int i = 0;
        while (i < 4) {
            if (data.bombMap[y + data.searchOrder[i][0]][x + data.searchOrder[i][1]] == 'B') {
                ++nr;
            }
            ++i;
        }
        return nr;
    }

    private static boolean inSafeSpot(GameData data, int x, int y) {
        return data.bombMap[y][x] != 'B';
    }

    private static boolean inSafeSpot(GameData data) {
        return data.bombMap[data.playerY][data.playerX] != 'B';
    }

    private static GameData.Action getMovementAction(GameData data, int newX, int newY) {
        if (newX > data.playerX) {
            return GameData.Action.GORIGHT;
        }
        if (newX < data.playerX) {
            return GameData.Action.GOLEFT;
        }
        if (newY > data.playerY) {
            return GameData.Action.GODOWN;
        }
        if (newY < data.playerY) {
            return GameData.Action.GOUP;
        }
        return GameData.Action.NOTHING;
    }

    private static Queue<GameData.Action> calculateBombPlacement(GameData data) {
        LinkedList<GameData.Action> queue = new LinkedList<GameData.Action>();
        boolean[][] explored = new boolean[data.mapHeight][data.mapWidth];
        int i = 0;
        while (i < 10) {
            int wx = data.playerX;
            int wy = data.playerY;
            int cx = wx;
            int cy = wy;
            explored[wy][wx] = true;
            int j = 0;
            while (j < 4) {
                int nx = cx + data.searchOrder[j][0];
                int ny = cy + data.searchOrder[j][1];
                if (!(Main.getWallAtPosition(data, nx, ny) || explored[ny][nx] || Main.getBombThreatAtPosition(data, nx, ny))) {
                    if (Main.getSurroundingWallsAtPosition(data, nx, ny) == 3) {
                        queue.add(Main.getMovementAction(data, nx, ny));
                        queue.add(GameData.Action.PLACEBOMB);
                        return queue;
                    }
                    wx = nx;
                    wy = ny;
                }
                ++j;
            }
            if (!Main.getBombThreatAtPosition(data, wx, wy)) {
                GameData.Action a = Main.getMovementAction(data, wx, wy);
                if (a != GameData.Action.NOTHING) {
                    queue.add(a);
                }
            } else {
                queue.clear();
                return queue;
            }
            data.playerX = wx;
            data.playerY = wy;
            ++i;
        }
        int j = 0;
        while (j < data.activePlayers) {
            if (Math.abs(data.players[j][0] - data.playerX) == 1 || Math.abs(data.players[j][1] - data.playerY) == 1) {
                queue.clear();
                queue.add(GameData.Action.PLACEBOMB);
            }
            ++j;
        }
        return queue;
    }

    private static Queue<GameData.Action> calculateSafeSpot(GameData data) {
        LinkedList<GameData.Action> queue = new LinkedList<GameData.Action>();
        boolean[][] explored = new boolean[data.mapHeight][data.mapWidth];
        int i = 0;
        while (i < 15 && !Main.inSafeSpot(data)) {
            int wx = data.playerX;
            int wy = data.playerY;
            int cx = wx;
            int cy = wy;
            explored[wy][wx] = true;
            int j = 0;
            while (j < 4) {
                int nx = cx + data.searchOrder[j][0];
                int ny = cy + data.searchOrder[j][1];
                if (!Main.getWallAtPosition(data, nx, ny) && !explored[ny][nx]) {
                    if (Main.inSafeSpot(data, nx, ny)) {
                        queue.add(Main.getMovementAction(data, nx, ny));
                        return queue;
                    }
                    wx = nx;
                    wy = ny;
                }
                ++j;
            }
            queue.add(Main.getMovementAction(data, wx, wy));
            data.playerX = wx;
            data.playerY = wy;
            ++i;
        }
        return queue;
    }
}

