/**
 * ...
 * @author Henri Sarasvirta
 */
wideload.XORShader =
{
	attributes:{
		
	},
	
	uniforms:{
		zoom: {type:"f", value: 0.6},
		resolution: {type:"v2", value: new THREE.Vector2(8,8)},
		time: {type:"f", value: 164.0},
	},
	
	vertex: [
		"varying vec3 vNormal;",
		
		"void main() {",
			"vNormal = normal;",
			"vec3 p = position;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",
		"}"
	].join("\n"),
	
	fragment:[
	"uniform vec2 resolution;",
	"uniform float time;",
	//"#define f(a,b)sin(17.3*length(gl_FragCoord.xy/resolution.xy*(1.5*sin(t)+1.0)*2.-vec2(cos(a),sin(b))-3.))",
	//"void main(){float t=time;gl_FragColor=vec4(f(t,t)*f(11.4*t,7.27*t));}"
	
	"void main(){",
	"float t = time;",
	
	"float d2 = sin(15.0*length(gl_FragCoord.xy / resolution.xy * 12.0- vec2(sin(t*13.0)*1.4+12.0,cos(t*0.4)*1.39+12.0)));",
	"float d1 = sin(15.0*length(gl_FragCoord.xy / resolution.xy * 12.0- vec2(sin(t*1.5)*1.2+12.0,cos(t*5.2)*1.2+12.0)));",
	
	"float r = smoothstep(0.0,1.0,d2*d1);// sin(d2*20.0+d1*17.0);",
	"float g = r;",
	"float b = r;",
	
	"gl_FragColor = vec4(r,g,b,0);",
"}"
/*
		"varying vec3 vNormal;",
		"uniform float time;",
		"float rand(vec2 co){",
			"return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);",
		"}",
		"void main() {",
			"vec2 uv = gl_FragCoord.xy;",
			"float rnd = rand(vec2(uv.x+uv.y + time, uv.y+uv.x + time));",
			
			"gl_FragColor = vec4(rnd*0.6,rnd*0.6,rnd*0.6,0);",
		"}"*/
	].join("\n")
}