/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	var Test = function(main, renderCacheAmount, partId){
		this.partId = partId;
		this.main = main;
		this.renderer = null; //Renderer is given from outside.
		this.renderTarget = null; //Create render target on initialize.
	}
	var p = Test.prototype = new wideload.BasePart();
	wideload.Test = Test;
	
	p.superInitialize = p.initialize;
	p.initialize = function(renderer){
		this.superInitialize(renderer);
		this.maxX = this.main.resolution[0]/2;
		this.minX = -this.main.resolution[0]/2;
		this.maxY = this.main.resolution[1]/2;
		this.minY = -this.main.resolution[1]/2;
		
		this.camera = new THREE.OrthographicCamera(this.minX,this.maxX, this.maxY, this.minY);
		
		this.shaderMaterial = new THREE.ShaderMaterial({
			uniforms: wideload.NoiseShader.uniforms,
			attributes: wideload.NoiseShader.attributes,
			vertexShader: wideload.NoiseShader.vertex,
			fragmentShader: wideload.NoiseShader.fragment,
			color: "white"
		});
		
		var planeGeom = new THREE.PlaneGeometry(this.main.resolution[0], this.main.resolution[1]);
		var plane = new THREE.Mesh(planeGeom, this.shaderMaterial);
		this.scene.add(plane);
		
		this.camera.position.z = 10;
		
		this.isActive = true;
	}
	
	/*
	Overwrite and do render here
	*/
	p.internalRender = function(elapsedtime,renderTarget){
		
		this.shaderMaterial.uniforms.resolution.value.x = $("#demo canvas").width()/2;
		this.shaderMaterial.uniforms.resolution.value.y = $("#demo canvas").height()/2;
		
		this.shaderMaterial.uniforms.time.value = elapsedtime*0.0002;
		this.renderer.render(this.scene, this.camera, renderTarget);
	}
	
	
})();

