/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	var DemoName = function(main, renderCacheAmount, partId){
		this.partId = partId;
		this.main = main;
		this.renderer = null; //Renderer is given from outside.
		this.renderTarget = null; //Create render target on initialize.
	}
	var p = DemoName.prototype = new wideload.BasePart();
	wideload.DemoName = DemoName;
	
	p.superInitialize = p.initialize;
	p.initialize = function(renderer){
		this.superInitialize(renderer);
		
				camera = new THREE.PerspectiveCamera( 50, window.innerWidth / window.innerHeight, 1, 1000 );
				camera.position.set( 0, 150, 500 );

				scene = new THREE.Scene();

				var theText = "Hello three.js! :)";

				var text3d = new THREE.TextGeometry( theText, {

					size: 80,
					height: 20,
					curveSegments: 2,
					font: "helvetiker"

				});

				text3d.computeBoundingBox();
				var centerOffset = -0.5 * ( text3d.boundingBox.max.x - text3d.boundingBox.min.x );

				var textMaterial = new THREE.MeshBasicMaterial( { color: Math.random() * 0xffffff, overdraw: 0.5 } );
				text = new THREE.Mesh( text3d, textMaterial );

				text.position.x = centerOffset;
				text.position.y = 100;
				text.position.z = 0;

				text.rotation.x = 0;
				text.rotation.y = Math.PI * 2;

				group = new THREE.Object3D();
				group.add( text );

				scene.add( group );

		
		this.isActive = true;
	}
	
	/*
	Overwrite and do render here
	*/
	p.internalRender = function(elapsedtime,renderTarget){
		
	/*	this.shaderMaterial.uniforms.resolution.value.x = $("#demo canvas").width()/2;
		this.shaderMaterial.uniforms.resolution.value.y = $("#demo canvas").height()/2;
		
		this.shaderMaterial.uniforms.time.value = elapsedtime*0.0002;*/
		this.renderer.render(this.scene, this.camera, renderTarget);
	}
	
	
})();

