// Hard-coded sobel filter.
// ToDo: General convolution filter shader
#version 330 core

in vec2 UV;
//uniform vec2 iResolution;
uniform sampler2D inputtex;
const vec2 iResolution = vec2(1280.0, 720.0);
const vec2 px = vec2(1.0) / iResolution;

out vec4 color;

vec3 Gy( vec2 coord ) {
    vec3 outvec = vec3(0.0);
    outvec += 1.0 * texture(inputtex, UV - px).rgb;
    outvec += 2.0 * texture(inputtex, UV + vec2(0.0, -px.y)).rgb;
    outvec += 1.0 * texture(inputtex, UV + vec2(px.x, -px.y)).rgb;

    outvec += -1.0 * texture(inputtex, UV + vec2(-px.x, px.y)).rgb;
    outvec += -2.0 * texture(inputtex, UV + vec2(0.0, px.y)).rgb;
    outvec += -1.0 * texture(inputtex, UV + vec2(px.x, px.y)).rgb;
    return outvec;
}

vec3 Gx( vec2 coord ) {
    vec3 outvec = vec3(0.0);
    outvec += 1.0 * texture(inputtex, UV + vec2(-px.x, -px.y)).rgb;
    outvec += 2.0 * texture(inputtex, UV + vec2(-px.x, 0.0)).rgb;
    outvec += 1.0 * texture(inputtex, UV + vec2(-px.x, px.y)).rgb;
    
    outvec += -1.0 * texture(inputtex, UV + vec2(px.x, -px.y)).rgb;
    outvec += -2.0 * texture(inputtex, UV + vec2(px.x, 0.0)).rgb;
    outvec += -1.0 * texture(inputtex, UV + vec2(px.x, px.y)).rgb;
    return outvec;
}

float sobel(vec2 coord) {
    float x = length(Gx(coord));
    float y = length(Gy(coord));
    return sqrt(x * x + y * y);
}

void main(){
    vec3 output = vec3(sobel(UV));
    color = vec4(output, 1.0);
}
