#version 330 core

in vec2 UV;
uniform sampler2D texture0;  // colors
uniform sampler2D texture1;  // Velocity
uniform float scaler;

out vec4 color;

vec4 motionBlur(sampler2D color, sampler2D motion, vec2 uv, float intensity)
{
    vec2 speed = texture(motion, uv).rg;
    vec2 offset = intensity * speed * 16.8 / scaler;
    vec3 c = vec3(0.0);
    
    float inc = 0.1;
    float weight = 0.0;
    for (float i = 0.0; i <= 1.0; i += inc) {
        c += texture(color, uv + i * offset).rgb;
        weight += 1.0;
    }
    c /= weight;
    return vec4(c, 1.0);
}

void main(){
    color = motionBlur(texture0, texture1, UV, 1.0);
}
