game.EndScreen = me.ScreenObject.extend({
 
    /**   
     *  action to perform on state change
     */
    onResetEvent : function() {
         
        // title screen
        me.game.world.addChild(
            new me.SpriteObject (
                0,0,
                me.loader.getImage('win_screen')
            ),
            1
        );
     
        // add a new renderable component with the scrolling text
        me.game.world.addChild(new (me.Renderable.extend ({
            // constructor
            init : function() {
                this.parent(new me.Vector2d(0, 0), me.game.viewport.width, me.game.viewport.height);
                // font for the scrolling text
                this.font = new me.BitmapFont("32x32_font", 32);
                 
                 // a tween to animate the arrow
                this.scrollertween = new me.Tween(this).to({scrollerpos: -2200 }, 10000).onComplete(this.scrollover.bind(this)).start();
         
                this.scroller = "YOU MADE IT! REVISION IS SAFE FOR ANOTHER YEAR!       ";
                this.scrollerpos = 1024;
            },
             
            // some callback for the tween objects
            scrollover : function() {
                // reset to default value
                this.scrollerpos = 1024;
                this.scrollertween.to({scrollerpos: -2200 }, 10000).onComplete(this.scrollover.bind(this)).start();
            },
         
            update : function (dt) {
                return true;
            },
             
            draw : function (context) {
                this.font.draw (context, "PRESS ENTER TO PLAY AGAIN", 100, 720);
                this.font.draw(context, this.scroller, this.scrollerpos, 540);
            },
            onDestroyEvent : function() {
                //just in case
                this.scrollertween.stop();
            }
        })), 2);
         
        // change to play state on press Enter or click/tap
        me.input.bindKey(me.input.KEY.ENTER, "enter", true);
        me.input.bindPointer(me.input.mouse.LEFT, me.input.KEY.ENTER);
        this.handler = me.event.subscribe(me.event.KEYDOWN, function (action, keyCode, edge) {
            if (action === "enter") {
                // play something on tap / enter
                // this will unlock audio on mobile devices
                me.audio.play("cling");
                me.state.change(me.state.PLAY);
            }
        });
    },
 
    /**   
     *  action to perform when leaving this screen (state change)
     */
    onDestroyEvent : function() {
        me.input.unbindKey(me.input.KEY.ENTER);
        me.input.unbindPointer(me.input.mouse.LEFT);
        me.event.unsubscribe(this.handler);
   }
});

game.TitleScreen = me.ScreenObject.extend({
 
    /**   
     *  action to perform on state change
     */
    onResetEvent : function() {
         
        // title screen
        me.game.world.addChild(
            new me.SpriteObject (
                0,0,
                me.loader.getImage('title_screen')
            ),
            1
        );
     
        // add a new renderable component with the scrolling text
        me.game.world.addChild(new (me.Renderable.extend ({
            // constructor
            init : function() {
                this.parent(new me.Vector2d(0, 0), me.game.viewport.width, me.game.viewport.height);
                // font for the scrolling text
                this.font = new me.BitmapFont("32x32_font", 32);
				//this.font.set("right");
                 
                 // a tween to animate the arrow
                this.scrollertween = new me.Tween(this).to({scrollerpos: -4400 }, 10000).onComplete(this.scrollover.bind(this)).start();
         
                this.scroller = "SAVE REVISION BY SCRAPING OFF STICKERS FASTER THAN PEOPLE CAN PLACE THEM!     CODE BY JUMPIN JOE, GFX BY ATARI ST, SFX BY SEGA MOOSE-X       ";
                this.scrollerpos = 1024;
            },
             
            // some callback for the tween objects
            scrollover : function() {
                // reset to default value
                this.scrollerpos = 1024;
                this.scrollertween.to({scrollerpos: -4400 }, 10000).onComplete(this.scrollover.bind(this)).start();
            },
         
            update : function (dt) {
                return true;
            },
             
            draw : function (context) {
                this.font.draw (context, "PRESS ENTER TO PLAY", 400, 650);
                this.font.draw(context, this.scroller, this.scrollerpos, 720);
            },
            onDestroyEvent : function() {
                //just in case
                this.scrollertween.stop();
            }
        })), 2);
         
        // change to play state on press Enter or click/tap
        me.input.bindKey(me.input.KEY.ENTER, "enter", true);
        me.input.bindPointer(me.input.mouse.LEFT, me.input.KEY.ENTER);
        this.handler = me.event.subscribe(me.event.KEYDOWN, function (action, keyCode, edge) {
            if (action === "enter") {
                // play something on tap / enter
                // this will unlock audio on mobile devices
                me.audio.play("cling");
                me.state.change(me.state.PLAY);
            }
        });
    },
 
    /**   
     *  action to perform when leaving this screen (state change)
     */
    onDestroyEvent : function() {
        me.input.unbindKey(me.input.KEY.ENTER);
        me.input.unbindPointer(me.input.mouse.LEFT);
        me.event.unsubscribe(this.handler);
   }
});