game.PlayScreen = me.ScreenObject.extend({
	/**
	 *  action to perform on state change
	 */
	onResetEvent: function() {
		me.levelDirector.loadLevel("mainhall");
	
		// reset the score
		game.data.lost = false;
		game.data.nstickers = 0;
		game.data.maxstickers = 20;
		game.data.countdown = 120;
		game.data.stickerprob = 0.6;

		// add our HUD to the game world
		this.HUD = new game.HUD.Container();
		me.game.world.addChild(this.HUD);
		this.tickInterval = me.timer.setInterval(this.tick, 1000, true);
		
        me.input.bindKey(me.input.KEY.ESC, "escape", true);
        this.handler = me.event.subscribe(me.event.KEYDOWN, function (action, keyCode, edge) {
            if (action === "escape") {
                // play something on tap / enter
                // this will unlock audio on mobile devices
                me.state.change(me.state.MENU);
            }
        });

	},
	
	tick: function() {
		if (game.data.lost)
			return;
			
		game.data.countdown--;
		
		if (!game.data.countdown)
			me.state.change(me.state.GAME_END);
	},
	
	lose: function() {
		game.data.lost = true;
		var fail_screen = new me.SpriteObject(0, 0, me.loader.getImage("fail_screen"));
		fail_screen.floating = true;
		me.game.world.addChild(fail_screen, Infinity);
	},


	/**
	 *  action to perform when leaving this screen (state change)
	 */
	onDestroyEvent: function() {
		// remove the HUD from the game world
        me.input.unbindKey(me.input.KEY.ESC);
        me.event.unsubscribe(this.handler);
		me.timer.clearInterval(this.tickInterval);
		me.game.world.removeChild(this.HUD);
	}
});
