#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform float time;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 3) in vec4 TANGENT;
layout (location = 4) in vec2 TEXCOORD;

out vec3 normal;
out vec4 tangent;
out vec2 uv;

void main()
{
	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;
	tangent.xyz = NormalMatrix * TANGENT.xyz;
	tangent.w = TANGENT.w;

	vec4 pos = vec4(POSITION, 1.0);
	float t = time + pos.x + pos.z;
	float s = smoothstep(0.7, 12.5, pos.y) * 0.1;
	pos.x += sin(t) * s;
	pos.z += cos(t) * s;

	gl_Position = ModelViewProjectionMatrix * pos;
}
