#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform float terrainTexCoordScale;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 3) in vec4 TANGENT;
layout (location = 4) in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec4 tangent;
out vec3 ec_pos;
out vec2 uv;
out vec3 world_uvw;

void main()
{
	world_uvw = POSITION * terrainTexCoordScale;
	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;
	tangent.xyz = NormalMatrix * TANGENT.xyz;
	tangent.w = TANGENT.w;

	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));

	vec4 proj_pos = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
