#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform float CloudHeightScale;

in vec3 POSITION;
in vec3 NORMAL;

out vec3 ec_pos;
out vec4 diffuse;

#include <shading_model/atmosphere_include.frag>

void main()
{
	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	calculateSkydomeAtmosphere(POSITION*CloudHeightScale*2.0, diffuse);
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
