#version 430 core

uniform sampler2D gb_depth;
uniform vec2 viewport;

in vec3 ec_pos;
in vec4 diffuse;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

void main()
{
#if 0
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = (texture(gb_depth, uv_pos).x - 0.5)*2.0;
	vec3 pos = calc_position(uv_pos, d);
	if ( pos.z > ec_pos.z ) discard;

	frag_color = diffuse;
	//frag_color.a = 1.0;
	frag_color.a = clamp((ec_pos.z - pos.z)/16.0, 0.0, 1.0);
#else
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(gb_depth, uv_pos).x;
	if ( d < 1.0 ) discard;
	frag_color = diffuse;
	frag_color.a = 1.0;
#endif
}
