#version 430 core

uniform sampler2D particle;
uniform sampler2D gb_depth;
uniform vec2 viewport;

in vec2 uv;
in vec3 wpos;
in float fade;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = (texture(gb_depth, uv_pos).x - 0.5) * 2.0;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	float alpha = clamp((wpos.z - pos.z)*1.0, 0.0, 1.0);
	vec4 part = texture(particle, uv) * alpha * fade;
	frag_color = part*vec4(1.2, 1.0, 0.8, 1.0);
}
