#define USE_NORMAL_MAP
// #define USE_DETAIL_MAPS
// #define USE_PARALLAX
// #define USE_AO_MAP

uniform sampler2D diffusemap;  // diffuse rgb, emissive
uniform sampler2D specularmap; // specular rgb, smoothness
#ifdef ALPHA_MASK_MAP
uniform sampler2D alphamaskmap;
uniform vec4 alphamaskParams;
#endif

#ifdef USE_NORMAL_MAP
uniform sampler2D normalmap;   // normal xyz, 1
#endif // USE_NORMAL_MAP


#ifdef USE_DETAIL_MAPS
uniform sampler2D diffusedetailmap;  // diffuse rgb, emissive
#ifdef USE_NORMAL_MAP
uniform sampler2D normaldetailmap;  // normal xyz, 1
#endif // USE_NORMAL_MAP
uniform vec4 detailParams;           // offset, scale
#endif // USE_DETAIL_MAPS

#ifdef USE_PARALLAX
uniform sampler2D depthmap;   // height
uniform vec4 parallaxParams; // ?
#endif // USE_PARALLAX


#ifdef USE_AO_MAP
uniform sampler2D aomap;   // prebaked ambient occlusion
#endif // USE_AO_MAP


void sampleMaterial(in vec2 uv, in vec3 normal, in vec4 tangent)
{
#ifdef USE_PARALLAX
#endif

#ifdef ALPHA_MASK_MAP
	float mask = texture(alphamaskmap, uv).x;
	if ( mask < alphamaskParams.x )
	{
		discard;
		return;
	}
#endif

#ifdef USE_NORMAL_MAP
	vec3 t = normalize(tangent.xyz);
	vec3 n = normalize(normal);
	vec3 b = normalize(cross(t,n)*tangent.w);
	vec3 bn = texture(normalmap, uv).xyz*2.0 - vec3(1.0);
#ifdef USE_DETAIL_MAPS
	bn += texture(normaldetailmap, detailParams.xy + uv*detailParams.zw).xyz*2.0 - vec3(1.0);
#endif
	mat3 mr = mat3(t, b, n);
	vec3 n = normalize(mr * bn);
#else // !USE_NORMAL_MAP
	vec3 n = normalize(normal);
#endif

	vec4 diff = texture(diffusemap, uv);
#ifdef USE_DETAIL_MAPS
	diff.rgb *= texture(diffusedetailmap, detailParams.xy + uv*detailParams.zw).rgb;
#endif
	vec4 spec = texture(specularmap, uv);

#ifdef USE_AO_MAP
	float ao = texture(aomap, uv).r;
	diff.rgb *= ao;
	spec.rgb *= ao;
#endif

	gb_diffuse.rgb = diff.rgb;  // diffuse.rgb
	gb_diffuse.a = 0.0;

	gb_specular.rgb = spec.rgb; // specular rgb, smoothness
	gb_specular.a = spec.a;

	gb_normal.xyz = n;   // normal xyz, ?
	gb_normal.w = 0.0;

	gb_light.rgb = diff.rgb*diff.a;
	gb_light.a = 1.0;
}
