#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 NormalMatrix;
//uniform mat3 WorldNormalMatrix;
uniform float time;
uniform vec4 EmissionSphere; // xyz, radius

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 3) in vec4 TANGENT;
layout (location = 4) in vec2 TEXCOORD;

out vec3 normal;
out vec4 tangent;
out vec2 uv;
out float fade;

void main()
{
	time;
	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;
	tangent.xyz = NormalMatrix * TANGENT.xyz;
	tangent.w = TANGENT.w;

	vec4 pos = vec4(POSITION, 1.0);
	vec3 wpos = vec3(WorldMatrix * pos);
	//vec3 wnorm = WorldNormalMatrix * NORMAL;

	//float camLen = length( vec3(ModelViewMatrix * vec4(0.0,0.0,0.0,1.0)) );
	float camFade = 1.0 - (min(length( vec3(ModelViewMatrix * pos) ), 25.0) / 25.0);

	vec3 diff = EmissionSphere.xyz - wpos;
	float ft = time + dot(vec3(WorldMatrix * vec4(0.0,0.0,0.0,1.0)).xz, vec2(1.0))/3.14;
	//float ft = time + dot(wpos, vec3(1.0))/3.14;
	float fadePulse = sin(ft*4.0)*0.3 + 0.7;

	fade = camFade*fadePulse*0.9 + 0.1*(1.0 - (min(length(diff), EmissionSphere.w) / EmissionSphere.w));// * step(0.0, dot(diff, wnorm));

	float t = time + wpos.x + wpos.z;
	float len = length(pos.xyz);
	float s = smoothstep(0.1, 3.1, len) * 0.1;
	pos.x += sin(t) * s;
	pos.z += cos(t) * s;

	gl_Position = ModelViewProjectionMatrix * pos;
}
