#version 430 core

uniform sampler2D diffusemap;  // diffuse rgb, emissive
uniform sampler2D normalmap; // specular rgb, smoothness
uniform sampler2D emissivemap;
uniform float smoothness;

in vec3 normal;
in vec4 tangent;
in vec2 uv;

#include <deferred/gbuffer_write_include.frag>

void main()
{
	vec3 t = normalize(tangent.xyz);
	vec3 n = normalize(normal);
	//vec3 b = normalize( cross(n, t) * tangent.w );
	vec3 b = normalize( cross(n, t) );
	
	vec3 bn = texture(normalmap, uv).xyz*2.0 - vec3(1.0);
	mat3 mr = mat3(t, b, n);
	n = normalize(mr*bn);

	vec4 diff = texture(diffusemap, uv);
	float emis = texture(emissivemap, uv).x;

	gb_diffuse.rgb = diff.rgb;
	gb_diffuse.a = 0.0;

	gb_specular.rgb = diff.rgb * diff.a;
	gb_specular.a = smoothness;

	gb_normal.xyz = n;
	gb_normal.w = 0.0;

	gb_light.rgb = diff.rgb * emis * 2.0;
	gb_light.a = emis;
}
