#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 NormalMatrix;
layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
//layout (location = 4) in vec2 TEXCOORD;

out vec3 ec_pos;
out vec3 uvw;
out vec3 lightDir;
out vec4 extinction;
out vec3 inscatter;

#include <shading_model/atmosphere_include.frag>

void main()
{
	vec3 n = normalize(NormalMatrix * NORMAL);
	vec3 wPos = vec3(WorldMatrix * vec4(POSITION, 1.0));
	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));

	calculateGroundAtmosphere(wPos, n, extinction, inscatter);

	lightDir = SunPosition - ec_pos;
	uvw = ec_pos*(1.0/16.0);

	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
