#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec3 ec_pos;
out vec3 normal;
out vec2 uv;

void main()
{
	normal = NormalMatrix * NORMAL;
	uv = TEXCOORD;
	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
