#version 430 core

uniform mat4 ProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 4) in vec2 TEXCOORD;

out vec2 uv;
out vec3 wpos;

void main()
{
	uv = TEXCOORD;
	vec3 cpos = vec3(ModelViewMatrix * vec4(0.0, 0.0, 0.0, 1.0));
	wpos = cpos + POSITION;
	gl_Position = ProjectionMatrix * vec4(wpos, 1.0);
}
