#version 330 core

uniform sampler2D edge_buffer;
uniform sampler2D color_buffer;
uniform vec2 TexelSize;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

vec4 gaussSampler(in sampler2D smp, in vec2 uv)
{
#if 0
	vec4 color = texture(smp, uv+vec2(-TexelSize.x, TexelSize.y));
	color += texture(smp, uv+vec2(0.0, TexelSize.y)) * 2.0;
	color += texture(smp, uv+TexelSize);

	color += texture(smp, uv+vec2(-TexelSize.x, 0.0)) * 2.0;
	color += texture(smp, uv) * 4.0;
	color += texture(smp, uv+vec2(TexelSize.x, 0.0)) * 2.0;

	color += texture(smp, uv-vec2(-TexelSize.x, TexelSize.y));
	color += texture(smp, uv-vec2(0.0, TexelSize.y)) * 2.0;
	color += texture(smp, uv-TexelSize);
#else
	vec4 color = textureOffset(smp, uv, ivec2(-1, 1));
	color += textureOffset(smp, uv, ivec2(0, 1)) * 2.0;
	color += textureOffset(smp, uv, ivec2(1, 1));

	color += textureOffset(smp, uv, ivec2(-1, 0)) * 2.0;
	color += textureOffset(smp, uv, ivec2(0, 0)) * 4.0;
	color += textureOffset(smp, uv, ivec2(1, 0)) * 2.0;

	color += textureOffset(smp, uv, ivec2(-1, 1));
	color += textureOffset(smp, uv, ivec2(0, 1)) * 2.0;
	color += textureOffset(smp, uv, ivec2(-1, -1));
#endif
	color *= 1.0 / 16.0;
	return color; 
}


void main()
{
	vec4 original_color = texture(color_buffer, uv);
	vec4 color = gaussSampler(color_buffer, uv);
	float edge_factor = texture(edge_buffer, uv).r;
	
	frag_color = mix(original_color, color, edge_factor);
	//frag_color = vec4(original_color);
	//frag_color = vec4(edge_factor);
}
