#version 430 core

uniform sampler2D tex;
uniform vec2 TexelSize;

in vec2 texCoord;

layout (location = 0) out vec4 frag_color;

void main()
{

	// The parameters are hardcoded for now, but could be
	// made into uniforms to control from the program.
	float FXAA_SPAN_MAX = 8.0;
	float FXAA_REDUCE_MUL = 1.0/8.0;
	float FXAA_REDUCE_MIN = (1.0/128.0);

	vec3 rgbNW = texture(tex, texCoord + vec2(-1.0, -1.0)*TexelSize).xyz;
	vec3 rgbNE = texture(tex, texCoord + vec2(+1.0, -1.0)*TexelSize).xyz;
	vec3 rgbSW = texture(tex, texCoord + vec2(-1.0, +1.0)*TexelSize).xyz;
	vec3 rgbSE = texture(tex, texCoord + vec2(+1.0, +1.0)*TexelSize).xyz;
	vec3 rgbM  = texture(tex, texCoord).xyz;
	float emisM  = texture(tex, texCoord).w;

	vec3 luma = vec3(0.299, 0.587, 0.114);
	float lumaNW = dot(rgbNW, luma);
	float lumaNE = dot(rgbNE, luma);
	float lumaSW = dot(rgbSW, luma);
	float lumaSE = dot(rgbSE, luma);
	float lumaM = dot( rgbM, luma);

	float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
	float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));

	vec2 dir;
	dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
	dir.y = ((lumaNW + lumaSW) - (lumaNE + lumaSE));

	float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL), FXAA_REDUCE_MIN);

	float rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);

	dir = min(vec2(FXAA_SPAN_MAX, FXAA_SPAN_MAX),
				max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX), dir * rcpDirMin)) * TexelSize;

	vec3 rgbA = (1.0/2.0) * (
		texture(tex, texCoord + dir * (1.0/3.0 - 0.5)).xyz +
		texture(tex, texCoord + dir * (2.0/3.0 - 0.5)).xyz);
	vec3 rgbB = rgbA * (1.0/2.0) + (1.0/4.0) * (
		texture(tex, texCoord + dir * (0.0/3.0 - 0.5)).xyz +
		texture(tex, texCoord + dir * (3.0/3.0 - 0.5)).xyz);
	float lumaB = dot(rgbB, luma);

	if ( (lumaB < lumaMin) || (lumaB > lumaMax) )
	{
		frag_color.xyz = rgbA;
	}
	else
	{
		frag_color.xyz = rgbB;
	}
	// YEAH! we do gamma here because this is the last step that uses FP16
	frag_color.xyz = pow(frag_color.xyz, vec3(1.0/2.2));
	frag_color.w = emisM;
}

