#version 430 core

in vec3 gs_spot_dir[1];
in vec3 gs_spot_params[1]; // cone_angle, cone_cutoff_angle, radius
in vec3 gs_spot_color[1];  // rgb*intensity

out vec3 spot_pos;
out vec3 spot_dir;
out vec3 spot_params;
out vec3 spot_color;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT(VTX) \
	spot_pos = pos; \
	spot_dir = gs_spot_dir[0]; \
	spot_params = gs_spot_params[0]; \
	spot_color = gs_spot_color[0]; \
	gl_Position = VTX; \
	EmitVertex()

void main()
{
	vec3 pos = gl_in[0].gl_Position.xyz;

	EMIT(vec4(1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(1.0, -1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, -1.0, 1.0, 1.0));
	EndPrimitive();
}
