#version 430 core
uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform float NormalOffset;

layout (location = 0) in vec3 POSITION;
layout (location = 1) in vec3 NORMAL;
layout (location = 4) in vec2 TEXCOORD;

out vec3 light_pos; //x,y,z
out vec3 normal;
out vec2 uv;
out float falloff;

void main()
{
	vec3 pos = POSITION + NORMAL*NormalOffset;
	light_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;
	falloff = 1.0 - (abs(POSITION.z) / 10.0);
	gl_Position = ModelViewProjectionMatrix * vec4(pos, 1.0);
}
