#version 430 core

uniform mat4 ProjectionMatrix;
uniform vec3 XAxis;
uniform vec3 YAxis;

in vec3 gs_light_params[1]; // radius, width
in vec3 gs_light_color[1];
in vec3 gs_light_target[1];

out vec3 light_start;
out vec3 light_end;
out vec2 light_coeff; // radius, width
out vec3 color;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

void main()
{
	float radius = gs_light_params[0].x*1.5;
	float width = gs_light_params[0].y*1.5;
	if ( radius <= 0.0 || width <= 0.0 ) return;

	vec3 t = normalize(gl_in[0].gl_Position.xyz - gs_light_target[0]);
	vec3 n = normalize(gl_in[0].gl_Position.xyz + gs_light_target[0]);
	vec3 b = normalize(cross(t, n));
	n = normalize(cross(b, t));

	vec4 corners[4];
	corners[0] = ProjectionMatrix * vec4(gl_in[0].gl_Position.xyz + (n + b)*width, 1.0);
	corners[1] = ProjectionMatrix * vec4(gl_in[0].gl_Position.xyz + (b - n)*width, 1.0);
	corners[2] = ProjectionMatrix * vec4(gs_light_target[0] + (n - b)*width, 1.0);
	corners[3] = ProjectionMatrix * vec4(gs_light_target[0] + (-n - b)*width, 1.0);
	for (int i=0; i < 4; i++)
	{
		light_start = gl_in[0].gl_Position.xyz;
		light_end = gs_light_target[0];
		light_coeff = gs_light_params[0].xy;
		color = gs_light_color[0];

		vec4 vpos = corners[i] / abs(corners[i].w);
		vpos.zw = vec2(1.0);
		vpos.xy = clamp(vpos.xy, -1.0, 1.0);
		gl_Position = vpos;
		EmitVertex();
	}
	EndPrimitive();
}
